/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.mservice;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bsc.bcc.common.api.KbdusClient;
import kd.bsc.bcc.common.dao.ServiceCenterDao;
import kd.bsc.bea.common.api.KedasClient;
import kd.bsc.bea.common.model.ChainDataType;
import kd.bsc.bea.common.model.ChainDataTypeList;
import kd.bsc.bea.common.model.Entry;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.exception.BeaMserviceErrorCode;
import kd.bsc.bea.mservice.api.ChainDataTypeService;
import kd.bsc.bea.util.ParseSchemaUtil;

public class ChainDataTypeServiceImpl
implements ChainDataTypeService {
    private static final Log log = LogFactory.getLog(ChainDataTypeServiceImpl.class);

    public Map<String, Object> querySchemas(Long serviceCenterPkId) {
        if (serviceCenterPkId == null) {
            throw new KDBizException(BeaMserviceErrorCode.NULL_PARAM_EXCEPTION, new Object[0]);
        }
        return this.getChainDataTypeList(serviceCenterPkId, 0, 10);
    }

    public Map<String, Object> querySchemas(Long serviceCenterPkId, Integer offset, Integer limit) {
        if (serviceCenterPkId == null || offset == null || limit == null) {
            throw new KDBizException(BeaMserviceErrorCode.NULL_PARAM_EXCEPTION, new Object[0]);
        }
        return this.getChainDataTypeList(serviceCenterPkId, offset, limit);
    }

    public Map<String, Object> saveSchemaByName(Long serviceCenterPkId, String name) {
        List entries;
        if (serviceCenterPkId == null || name == null) {
            throw new KDBizException(BeaMserviceErrorCode.NULL_PARAM_EXCEPTION, new Object[0]);
        }
        DynamicObject serviceCenter = this.queryServiceCenter(serviceCenterPkId);
        String clientId = serviceCenter.getString("clientid");
        String clientSecret = serviceCenter.getString("clientsecret");
        String chainName = serviceCenter.getString("chainname");
        String bduid = serviceCenter.getString("bduid");
        ChainDataType chainDataType = new ChainDataType();
        try {
            String accessToken = KbdusClient.getToken((String)clientId, (String)clientSecret).getAccessToken();
            chainDataType = KedasClient.querySchemaByName((String)chainName, (String)accessToken, (String)bduid, (String)name);
        }
        catch (KDException e) {
            this.commonHandleException(e);
        }
        if (chainDataType == null) {
            throw new KDBizException(BeaMserviceErrorCode.CHAIN_DATA_TYPE_SAVE_FAIL_EXCEPTION, new Object[0]);
        }
        LinkedList<String> dataTypeStatus = new LinkedList<String>();
        dataTypeStatus.add("registered");
        dataTypeStatus.add("associated");
        QFilter filter = new QFilter("name", "=", (Object)name).and("status", "=", (Object)"C").and("datatypestatus", "in", dataTypeStatus).and("service_center_id", "=", (Object)serviceCenterPkId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bea_datatype", (String)"number,datatypeid", (QFilter[])filter.toArray());
        if (dynamicObjects.length > 0) {
            chainDataType.setPkId((Long)dynamicObjects[0].getPkValue());
            chainDataType.setNumber(dynamicObjects[0].getString("number"));
            chainDataType.setServiceCenterPkId((Long)serviceCenter.getPkValue());
            return JsonUtil.parseToMap((Object)chainDataType);
        }
        DynamicObject dataType = BusinessDataServiceHelper.newDynamicObject((String)"bea_datatype");
        dataType.set("name", (Object)chainDataType.getName());
        dataType.set("service_center_id", serviceCenter.getPkValue());
        dataType.set("datatypeid", (Object)chainDataType.getSchemaId());
        dataType.set("structure_tag", (Object)chainDataType.getStructure());
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        dataType.set("creator", (Object)userId);
        dataType.set("createtime", (Object)new Date());
        dataType.set("modifier", (Object)userId);
        dataType.set("modifytime", (Object)new Date());
        dataType.set("status", (Object)"C");
        dataType.set("datatypestatus", (Object)"registered");
        dataType.set("enable", (Object)"1");
        try {
            entries = ParseSchemaUtil.parseJsonSchema((String)chainDataType.getStructure());
        }
        catch (Exception e) {
            throw new KDBizException(BeaMserviceErrorCode.STRUCTURE_PARSE_FAIL_EXCEPTION, new Object[0]);
        }
        int count = entries.size();
        if (!entries.isEmpty()) {
            DynamicObjectCollection entryEntity = dataType.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < count; ++i) {
                Entry entry = (Entry)entries.get(i);
                DynamicObject dynamicObject = entryEntity.addNew();
                dynamicObject.set("entryname", (Object)entry.getName());
                dynamicObject.set("entryrequired", (Object)entry.getRequired());
                dynamicObject.set("entrytype", (Object)entry.getType());
                dynamicObject.set("entrydesc", (Object)entry.getDescription());
            }
        }
        String dataTypeNumber = CodeRuleServiceHelper.getNumber((String)"bea_datatype", (DynamicObject)dataType, null);
        dataType.set("number", (Object)dataTypeNumber);
        Object[] objects = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataType});
        if (objects.length == 0) {
            throw new KDBizException(BeaMserviceErrorCode.CHAIN_DATA_TYPE_SAVE_FAIL_EXCEPTION, new Object[0]);
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bea_datatype", (String)"datatypeid", (QFilter[])new QFilter("number", "=", (Object)dataTypeNumber).toArray());
        chainDataType.setPkId((Long)dynamicObject.getPkValue());
        chainDataType.setNumber(dataTypeNumber);
        chainDataType.setServiceCenterPkId((Long)serviceCenter.getPkValue());
        return JsonUtil.parseToMap((Object)chainDataType);
    }

    private Map<String, Object> getChainDataTypeList(Long serviceCenterPkId, Integer offset, Integer limit) {
        DynamicObject serviceCenter = this.queryServiceCenter(serviceCenterPkId);
        String clientId = serviceCenter.getString("clientid");
        String clientSecret = serviceCenter.getString("clientsecret");
        String chainName = serviceCenter.getString("chainname");
        String bduid = serviceCenter.getString("bduid");
        ChainDataTypeList chainDataTypeList = null;
        try {
            String accessToken = KbdusClient.getToken((String)clientId, (String)clientSecret).getAccessToken();
            chainDataTypeList = KedasClient.querySchemas((String)chainName, (String)accessToken, (String)bduid, (Integer)offset, (Integer)limit);
        }
        catch (KDException e) {
            this.commonHandleException(e);
        }
        List chainDataTypes = chainDataTypeList.getDatas();
        if (chainDataTypes.size() == 0) {
            return JsonUtil.parseToMap((Object)ChainDataTypeList.emptyChainDataTypeList());
        }
        QFilter filter = new QFilter("service_center_id", "=", (Object)serviceCenterPkId);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bea_datatype", (String)"datatypeid", (QFilter[])filter.toArray());
        for (ChainDataType chainDataType : chainDataTypes) {
            chainDataType.setSynchronized(Boolean.valueOf(this.exists(chainDataType.getSchemaId(), dynamicObjects)));
        }
        chainDataTypeList.setDatas(chainDataTypes);
        return JsonUtil.parseToMap((Object)chainDataTypeList);
    }

    private DynamicObject queryServiceCenter(Long serviceCenterPkId) {
        DynamicObject serviceCenter = null;
        try {
            serviceCenter = BusinessDataServiceHelper.loadSingle((Object)serviceCenterPkId, (String)"bcc_service_center", (String)ServiceCenterDao.getSelectProps());
        }
        catch (KDException e) {
            throw new KDBizException(BeaMserviceErrorCode.ERROR_SERVICE_CENTER_NUMBER_EXCEPTION, new Object[0]);
        }
        if (serviceCenter == null) {
            throw new KDBizException(BeaMserviceErrorCode.ERROR_SERVICE_CENTER_NUMBER_EXCEPTION, new Object[0]);
        }
        return serviceCenter;
    }

    private boolean exists(String dataTypeId, DynamicObject[] dynamicObjects) {
        if (dynamicObjects.length < 1) {
            return false;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dataTypeId.equals(dynamicObject.getString("datatypeid"))) continue;
            return true;
        }
        return false;
    }

    private void commonHandleException(KDException e) {
        String message = e.getMessage();
        String errorCode = e.getErrorCode().getCode();
        if (null != e.getErrorCode()) {
            log.error("API\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u7801\u4e3a\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)errorCode, (Object)message);
        } else {
            log.error("API\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)message);
        }
        if ("61001".equals(errorCode)) {
            throw new KDBizException(BeaMserviceErrorCode.INVALID_CLIENT_EXCEPTION, new Object[0]);
        }
        if ("61002".equals(errorCode)) {
            throw new KDBizException(BeaMserviceErrorCode.CLIENT_STATUS_DISABLE_EXCEPTION, new Object[0]);
        }
        if ("61004".equals(errorCode)) {
            throw new KDBizException(BeaMserviceErrorCode.NETWORK_NOT_RUNNING_EXCEPTION, new Object[0]);
        }
        if ("61005".equals(errorCode)) {
            throw new KDBizException(BeaMserviceErrorCode.CHAIN_NOT_FOUND_EXCEPTION, new Object[0]);
        }
        if ("61006".equals(errorCode)) {
            throw new KDBizException(BeaMserviceErrorCode.CHAIN_STATUS_FORBID_EXCEPTION, new Object[0]);
        }
        if ("61012".equals(errorCode)) {
            throw new KDBizException(BeaMserviceErrorCode.CONTRACT_NOT_FOUND_EXCEPTION, new Object[0]);
        }
        throw new KDBizException(BeaMserviceErrorCode.BLOCK_CHAIN_ERROR_EXCEPTION, new Object[0]);
    }
}

