/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bsc.bea.exception.BeaMserviceErrorCode;
import kd.bsc.bea.helper.BeaSchemeHelper;
import kd.bsc.bea.mservice.api.SchemeInitService;

public class SchemeInitServiceImpl
implements SchemeInitService {
    public Map<String, List<Map<String, Object>>> initScheme(String schemeNumber) {
        this.checkParam(schemeNumber);
        BeaSchemeHelper.initScheme((String)schemeNumber);
        return this.getAllResult(schemeNumber);
    }

    public Map<String, List<Map<String, Object>>> initSchemeAndStartTasks(String schemeNumber) {
        this.checkParam(schemeNumber);
        BeaSchemeHelper.initScheme((String)schemeNumber);
        BeaSchemeHelper.startTasks((String)schemeNumber);
        return this.getAllResult(schemeNumber);
    }

    private void checkParam(String schemeNumber) {
        if (StringUtils.isEmpty((CharSequence)schemeNumber)) {
            throw new KDBizException(BeaMserviceErrorCode.NULL_PARAM_EXCEPTION, new Object[0]);
        }
    }

    private Map<String, List<Map<String, Object>>> getAllResult(String schemeNumber) {
        QFilter filter = new QFilter("number", "=", (Object)schemeNumber);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"bea_scheme", (String)"datatype.datatype_no,mapping.mapping_no,task.task_no", (QFilter[])filter.toArray());
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(3);
        result.put("dataTypes", this.getDataTypeResult(scheme));
        result.put("mappings", this.getMappingResult(scheme));
        result.put("tasks", this.getTaskResult(scheme));
        return result;
    }

    private List<Map<String, Object>> getDataTypeResult(DynamicObject scheme) {
        DynamicObjectCollection schemeDataType = scheme.getDynamicObjectCollection("datatype");
        List dataTypeNumbers = schemeDataType.stream().map(d -> d.getString("datatype_no")).collect(Collectors.toList());
        QFilter dataTypeFilter = new QFilter("number", "in", dataTypeNumbers);
        DynamicObject[] dataTypes = BusinessDataServiceHelper.load((String)"bea_datatype", (String)"number", (QFilter[])dataTypeFilter.toArray());
        return this.getPkIdsAndNumbers("datatype", dataTypes);
    }

    private List<Map<String, Object>> getMappingResult(DynamicObject scheme) {
        DynamicObjectCollection schemeMapping = scheme.getDynamicObjectCollection("mapping");
        List mappingNumbers = schemeMapping.stream().map(m -> m.getString("mapping_no")).collect(Collectors.toList());
        QFilter mappingFilter = new QFilter("number", "in", mappingNumbers);
        DynamicObject[] mappings = BusinessDataServiceHelper.load((String)"bea_mapping", (String)"number", (QFilter[])mappingFilter.toArray());
        return this.getPkIdsAndNumbers("mapping", mappings);
    }

    private List<Map<String, Object>> getTaskResult(DynamicObject scheme) {
        DynamicObjectCollection schemeTask = scheme.getDynamicObjectCollection("task");
        List taskNumbers = schemeTask.stream().map(t -> t.getString("task_no")).collect(Collectors.toList());
        QFilter taskFilter = new QFilter("billno", "in", taskNumbers);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"bea_task", (String)"billno", (QFilter[])taskFilter.toArray());
        return this.getPkIdsAndNumbers("task", tasks);
    }

    private List<Map<String, Object>> getPkIdsAndNumbers(String identify, DynamicObject[] dynamicObjects) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("pkId", dynamicObject.getPkValue());
            if ("task".contains(identify)) {
                map.put("number", dynamicObject.get("billno"));
            } else {
                map.put("number", dynamicObject.get("number"));
            }
            result.add(map);
        }
        return result;
    }
}

