/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bsc.bea.common.model.MappingEntry;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.dao.MappingBizDataQueryHelper;
import kd.bsc.bea.exception.BeaMserviceErrorCode;
import kd.bsc.bea.mservice.api.StcLogService;
import kd.bsc.bea.mservice.model.ChainLog;
import kd.bsc.bea.mservice.model.ChainLogList;
import kd.bsc.bea.mservice.model.ComparingResults;
import kd.bsc.bea.mservice.model.ComparingValue;
import kd.bsc.bea.task.TaskUtil;
import kd.bsc.bea.util.MappingUtil;

public class StcLogServiceImpl
implements StcLogService {
    private static final Log log = LogFactory.getLog(StcLogServiceImpl.class);
    private static final int MAX_SIZE = 100;

    public Map<String, Object> queryStcLog(String bizObjNo, String bizBillNo) {
        return this.queryStcLogResults(bizObjNo, bizBillNo, 0, 10);
    }

    public Map<String, Object> queryStcLog(String bizObjNo, String bizBillNo, Integer pageIndex, Integer pageSize) {
        if (pageSize > 100) {
            pageSize = 100;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        return this.queryStcLogResults(bizObjNo, bizBillNo, pageIndex, pageSize);
    }

    public Map<String, Object> checkStcLog(String no) {
        ComparingResults comparedResults = new ComparingResults();
        comparedResults.setResult(Boolean.TRUE);
        String selectFields = "createtime,mappingno,bizobjno,bizbillno,entryentity.name,entryentity.type,entryentity.desc,entryentity.value,entryentity.value_tag";
        QFilter currentFilter = new QFilter("no", "=", (Object)no);
        DynamicObject[] currentLogs = BusinessDataServiceHelper.load((String)"bea_stc_log", (String)selectFields, (QFilter[])currentFilter.toArray());
        if (currentLogs.length == 1) {
            QFilter filter;
            DynamicObjectCollection currentCollection = currentLogs[0].getDynamicObjectCollection("entryentity");
            LinkedList<ComparingValue> comparingValues = new LinkedList<ComparingValue>();
            String mappingNo = currentLogs[0].getString("mappingno");
            String bizObjNo = currentLogs[0].getString("bizobjno");
            String bizBillNo = currentLogs[0].getString("bizbillno");
            DynamicObject mappingObject = ORM.create().queryOne("bea_mapping", new QFilter("number", "=", (Object)mappingNo).toArray());
            if (mappingObject == null) {
                return this.handleNull(comparedResults, currentCollection, comparingValues);
            }
            DynamicObjectCollection entries = mappingObject.getDynamicObjectCollection("mapping_entry");
            TaskUtil.collectionSort((DynamicObjectCollection)entries);
            Map mappingEntryMap = MappingUtil.getMappingEntryMap((DynamicObjectCollection)entries);
            ArrayList<MappingEntry> mappingEntries = new ArrayList<MappingEntry>(16);
            for (Map.Entry entry : mappingEntryMap.entrySet()) {
                MappingEntry mappingEntry = (MappingEntry)entry.getValue();
                mappingEntries.add(mappingEntry);
            }
            String selectProp = MappingBizDataQueryHelper.constructSelectProp(mappingEntries);
            DynamicObject bizModelData = BusinessDataServiceHelper.loadSingle((String)bizObjNo, (String)selectProp, (QFilter[])(filter = new QFilter("billno", "=", (Object)bizBillNo)).toArray());
            if (bizModelData == null) {
                return this.handleNull(comparedResults, currentCollection, comparingValues);
            }
            Map dataMap = new HashMap(16);
            try {
                dataMap = TaskUtil.parseMappingEntry((DynamicObject)mappingObject, (DynamicObject)bizModelData);
            }
            catch (KDException e) {
                log.error("\u5b58\u8bc1\u65e5\u5fd7\u5fae\u670d\u52a1-\u6838\u9a8c\u5931\u8d25\uff0c\u5806\u6808\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getStackTraceMessage());
                String message = e.getErrorCode().getMessage();
                throw new KDBizException(BeaMserviceErrorCode.UNKNOWN_EXCEPTION, new Object[]{message});
            }
            DynamicObject stcLog = BusinessDataServiceHelper.newDynamicObject((String)"bea_stc_log");
            DynamicObjectCollection recalculatedLogEntries = stcLog.getDynamicObjectCollection("entryentity");
            Set entrySet = mappingEntryMap.entrySet();
            for (Map.Entry entry : entrySet) {
                MappingEntry mappingEntry = (MappingEntry)entry.getValue();
                DynamicObject entryObject = recalculatedLogEntries.addNew();
                TaskUtil.parseValue(dataMap, (MappingEntry)mappingEntry, (DynamicObject)entryObject);
            }
            for (int i = 0; i < recalculatedLogEntries.size(); ++i) {
                String currentValue = ((DynamicObject)recalculatedLogEntries.get(i)).getString("value");
                String currentValueTag = ((DynamicObject)recalculatedLogEntries.get(i)).getString("value_tag");
                String previousValue = ((DynamicObject)currentCollection.get(i)).getString("value");
                String previousValueTag = ((DynamicObject)currentCollection.get(i)).getString("value_tag");
                String name = ((DynamicObject)currentCollection.get(i)).getString("name");
                String type = ((DynamicObject)currentCollection.get(i)).getString("type");
                String desc = ((DynamicObject)currentCollection.get(i)).getString("desc");
                if (!currentValueTag.equals(previousValueTag)) {
                    comparedResults.setResult(Boolean.FALSE);
                    comparingValues.add(new ComparingValue(name, type, desc, previousValue, previousValueTag, currentValue, currentValueTag, Boolean.FALSE));
                    continue;
                }
                comparingValues.add(new ComparingValue(name, type, desc, previousValue, previousValueTag, currentValue, currentValueTag, Boolean.TRUE));
            }
            comparedResults.setComparingValueList(comparingValues);
        } else {
            comparedResults.setResult(Boolean.FALSE);
            comparedResults.setComparingValueList(Collections.emptyList());
        }
        return JsonUtil.parseToMap((Object)comparedResults);
    }

    public Map<String, Object> queryStcLogByMappingNo(String bizObjNo, String bizBillNo, String mappingNo) {
        return this.queryStcLogResultsByMappingNo(bizObjNo, bizBillNo, mappingNo, 0, 10);
    }

    public Map<String, Object> queryStcLogByMappingNo(String bizObjNo, String bizBillNo, String mappingNo, Integer pageIndex, Integer pageSize) {
        if (pageSize > 100) {
            pageSize = 100;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        return this.queryStcLogResultsByMappingNo(bizObjNo, bizBillNo, mappingNo, pageIndex, pageSize);
    }

    private Map<String, Object> queryStcLogResults(String bizObjNo, String bizBillNo, Integer pageIndex, Integer pageSize) {
        String selectFields = "no,createtime,txid,mappingno,mappingname,datatypeno,datatypename,taskno,taskname,status,retrytimes";
        QFilter qFilter = new QFilter("bizobjno", "=", (Object)bizObjNo).and("bizbillno", "=", (Object)bizBillNo).and("status", "=", (Object)"A");
        DynamicObject[] logList = BusinessDataServiceHelper.load((String)"bea_stc_log", (String)selectFields, (QFilter[])qFilter.toArray(), (String)"createtime DESC", (int)pageIndex, (int)pageSize);
        ArrayList<ChainLog> chainLogs = new ArrayList<ChainLog>(16);
        for (DynamicObject dynamicObject : logList) {
            ChainLog chainLog = this.setChainLog(bizBillNo, dynamicObject);
            chainLogs.add(chainLog);
        }
        Long count = this.getStcLogNumber(bizObjNo, bizBillNo);
        ChainLogList chainLogList = new ChainLogList();
        chainLogList.setCount(count);
        chainLogList.setChainLogs(chainLogs);
        return JsonUtil.parseToMap((Object)chainLogList);
    }

    private Map<String, Object> queryStcLogResultsByMappingNo(String bizObjNo, String bizBillNo, String mappingNo, Integer pageIndex, Integer pageSize) {
        String selectFields = "no,createtime,txid,mappingno,mappingname,datatypeno,datatypename,taskno,taskname,status,retrytimes,entryentity.value_tag";
        QFilter qFilter = new QFilter("bizobjno", "=", (Object)bizObjNo).and("bizbillno", "=", (Object)bizBillNo).and("mappingno", "=", (Object)mappingNo).and("status", "=", (Object)"A");
        DynamicObject[] logList = BusinessDataServiceHelper.load((String)"bea_stc_log", (String)selectFields, (QFilter[])qFilter.toArray(), (String)"createtime DESC", (int)pageIndex, (int)pageSize);
        ChainLogList chainLogList = new ChainLogList();
        ArrayList<ChainLog> chainLogs = new ArrayList<ChainLog>(16);
        if (logList.length == 0) {
            return JsonUtil.parseToMap((Object)chainLogList);
        }
        Long count = this.getStcLogNumberByMappingNo(bizObjNo, bizBillNo, mappingNo);
        chainLogList.setCount(count);
        for (int i = 0; i < logList.length; ++i) {
            DynamicObject log = logList[i];
            ChainLog chainLog = this.setChainLog(bizBillNo, log);
            if (i == logList.length - 1) {
                chainLogs.add(chainLog);
                chainLogList.setChainLogs(chainLogs);
                return JsonUtil.parseToMap((Object)chainLogList);
            }
            DynamicObjectCollection currentCollection = log.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection previousCollection = logList[i + 1].getDynamicObjectCollection("entryentity");
            if (currentCollection != null && previousCollection != null) {
                TaskUtil.collectionSort((DynamicObjectCollection)currentCollection);
                TaskUtil.collectionSort((DynamicObjectCollection)previousCollection);
            }
            if (currentCollection == null && previousCollection == null) {
                chainLog.setIsChanged("NOCHANGE");
            } else if (currentCollection == null || previousCollection == null) {
                chainLog.setIsChanged("CHANGE");
            } else if (this.equals(currentCollection, previousCollection)) {
                chainLog.setIsChanged("NOCHANGE");
            } else {
                chainLog.setIsChanged("CHANGE");
            }
            chainLogs.add(chainLog);
        }
        chainLogList.setChainLogs(chainLogs);
        return JsonUtil.parseToMap((Object)chainLogList);
    }

    private Long getStcLogNumber(String bizObjNo, String bizBillNo) {
        QFilter qFilter = new QFilter("bizobjno", "=", (Object)bizObjNo).and("bizbillno", "=", (Object)bizBillNo).and("status", "=", (Object)"A");
        ORM orm = ORM.create();
        Integer count = orm.count(this.getClass().getName() + "-" + "bea_stc_log", "bea_stc_log", qFilter.toArray());
        return count.longValue();
    }

    private Long getStcLogNumberByMappingNo(String bizObjNo, String bizBillNo, String mappingNo) {
        QFilter qFilter = new QFilter("bizobjno", "=", (Object)bizObjNo).and("bizbillno", "=", (Object)bizBillNo).and("mappingno", "=", (Object)mappingNo).and("status", "=", (Object)"A");
        ORM orm = ORM.create();
        Integer count = orm.count(this.getClass().getName() + "-" + "bea_stc_log", "bea_stc_log", qFilter.toArray());
        return count.longValue();
    }

    private ChainLog setChainLog(String bizBillNo, DynamicObject dynamicObject) {
        String no = dynamicObject.getString("no");
        Long createTime = dynamicObject.getDate("createtime").getTime();
        String txId = dynamicObject.getString("txid");
        String mappingNo = dynamicObject.getString("mappingno");
        String mappingName = dynamicObject.getString("mappingname");
        String datatypeNo = dynamicObject.getString("datatypeno");
        String datatypeName = dynamicObject.getString("datatypename");
        String taskNo = dynamicObject.getString("taskno");
        String taskName = dynamicObject.getString("taskname");
        String status = dynamicObject.getString("status");
        Integer retryTimes = dynamicObject.getInt("retrytimes");
        return new ChainLog(no, createTime, txId, mappingNo, mappingName, datatypeNo, datatypeName, taskNo, taskName, bizBillNo, status, retryTimes, "NULL");
    }

    private boolean equals(DynamicObjectCollection currentCollection, DynamicObjectCollection previousCollection) {
        int i = 0;
        for (DynamicObject currentObject : currentCollection) {
            if (!currentObject.getString("value_tag").equals(((DynamicObject)previousCollection.get(i)).get("value_tag"))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Map<String, Object> handleNull(ComparingResults comparedResults, DynamicObjectCollection currentCollection, List<ComparingValue> comparingValues) {
        comparedResults.setResult(Boolean.FALSE);
        for (DynamicObject currentObject : currentCollection) {
            String name = currentObject.getString("name");
            String type = currentObject.getString("type");
            String desc = currentObject.getString("desc");
            String previousValue = currentObject.getString("value");
            String previousValueTag = currentObject.getString("value_tag");
            comparingValues.add(new ComparingValue(name, type, desc, previousValue, previousValueTag, "", "", Boolean.FALSE));
        }
        comparedResults.setComparingValueList(comparingValues);
        return JsonUtil.parseToMap((Object)comparedResults);
    }
}

