/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.mservice;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bsc.bea.common.dao.TaskManageDao;
import kd.bsc.bea.common.model.MicroServiceParam;
import kd.bsc.bea.common.util.BeaFeedbackUtils;
import kd.bsc.bea.common.util.DateUtil;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.exception.BeaMserviceErrorCode;
import kd.bsc.bea.mservice.api.StcTaskService;
import kd.bsc.bea.servicehelper.BizModelDataQueryServiceHelper;
import kd.bsc.bea.task.BlockchainTaskHelper;
import kd.bsc.bea.task.TaskUtil;

public class StcTaskServiceImpl
implements StcTaskService {
    private static final Log log = LogFactory.getLog(StcTaskServiceImpl.class);
    public static final String ONCE_TASK_CRON_TEMPLATE = "%s %s %s %s %s ? %s";

    public String toChain(String taskNo, String billNo) {
        DynamicObject taskManagement = TaskManageDao.getTaskManagement((String)taskNo);
        if (null == taskManagement) {
            throw new KDBizException(BeaMserviceErrorCode.ILLEGAL_TO_CHAIN_ID_EXCEPTION, new Object[]{taskNo});
        }
        String billStatus = taskManagement.getString("billstatus");
        String taskName = taskManagement.getString("name");
        if (!"C".equals(billStatus)) {
            return ResManager.loadKDString((String)"\u975e\u5f00\u542f\u72b6\u6001\u7684\u4e0a\u94fe\u4efb\u52a1\u65e0\u6cd5\u89e6\u53d1\u4e8b\u4ef6\u56de\u8c03\uff0c\u8df3\u8fc7\u4e0a\u94fe\u5904\u7406", (String)"StcTaskServiceImpl_0", (String)"bsc-bea-mservice", (Object[])new Object[0]);
        }
        DynamicObjectCollection mappings = taskManagement.getDynamicObjectCollection("mappings");
        Long mappingPkId = ((DynamicObject)mappings.get(0)).getLong("fbasedataid_id");
        DynamicObject mappingObject = BusinessDataServiceHelper.loadSingle((Object)mappingPkId, (String)"bea_mapping");
        List<DynamicObject> bizModelDataRows = StcTaskServiceImpl.queryBizModelData(mappingObject, billNo);
        if (!bizModelDataRows.isEmpty()) {
            TaskUtil.mappingTransformAndUpload((String)taskNo, (String)taskName, (DynamicObject)mappingObject, (DynamicObject[])bizModelDataRows.toArray(new DynamicObject[0]));
            this.updateRecordDate(taskNo);
        }
        return ResManager.loadKDString((String)"\u4e8b\u4ef6\u89e6\u53d1\u6210\u529f\uff0c\u4e0a\u94fe\u4efb\u52a1\u542f\u52a8", (String)"StcTaskServiceImpl_1", (String)"bsc-bea-mservice", (Object[])new Object[0]);
    }

    public List<Map<String, Object>> startTasks(List<Long> taskPkIds) {
        DynamicObject[] taskList;
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>();
        DynamicObject beaTask = BusinessDataServiceHelper.newDynamicObject((String)"bea_task");
        for (DynamicObject taskObject : taskList = BusinessDataServiceHelper.load((Object[])taskPkIds.toArray(), (DynamicObjectType)beaTask.getDynamicObjectType())) {
            String taskBillNo = taskObject.getString("billno");
            String taskType = taskObject.getString("type");
            String billStatus = taskObject.getString("billstatus");
            if ("schedule_task".equals(taskType) && "D".equalsIgnoreCase(billStatus)) {
                String jobId = taskObject.getString("jobid");
                this.enableTaskAndUpdate(taskBillNo, jobId);
                continue;
            }
            String name = taskObject.getString("name");
            String cronExpression = this.getCronExpression(taskObject);
            Date STCDate = taskObject.getDate("stcdate");
            Long STCDateLong = null != STCDate ? Long.valueOf(STCDate.getTime()) : null;
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("billno", taskObject.getString("billno"));
            params.put("name", name);
            params.put("stcdate", STCDateLong);
            params.put("pkIds", this.handleMappingsToPks(taskObject));
            String type = taskObject.getString("type");
            try {
                if ("event_callback".equals(type)) {
                    this.startEventTask(billStatus, taskBillNo, params);
                    continue;
                }
                this.createTaskAndRecord(taskBillNo, name, cronExpression, params);
            }
            catch (KDException e) {
                log.error("\u4e0a\u94fe\u4efb\u52a1\u5f00\u542f\u5931\u8d25\uff0c\u5806\u6808\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getStackTraceMessage());
                HashMap<String, Object> errorInfo = new HashMap<String, Object>();
                String message = e.getMessage();
                String errorMessage = message.contains("\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef") ? BeaFeedbackUtils.getTipCronError() : message;
                errorInfo.put("taskPkId", taskObject.getPkValue());
                errorInfo.put("taskBillNo", taskBillNo);
                errorInfo.put("errorMessage", errorMessage);
                errorInfoList.add(errorInfo);
            }
        }
        return errorInfoList;
    }

    public List<Map<String, Object>> stopTasks(List<Long> taskPkIds) {
        DynamicObject[] taskList;
        ArrayList<Map<String, Object>> errorInfoList = new ArrayList<Map<String, Object>>();
        DynamicObject beaTask = BusinessDataServiceHelper.newDynamicObject((String)"bea_task");
        for (DynamicObject taskObject : taskList = BusinessDataServiceHelper.load((Object[])taskPkIds.toArray(), (DynamicObjectType)beaTask.getDynamicObjectType())) {
            if (!this.checkStcTaskStatusToStop(taskObject, errorInfoList)) continue;
            String taskBillNo = taskObject.getString("billno");
            String jobId = taskObject.getString("jobid");
            String type = taskObject.getString("type");
            try {
                if (!"event_callback".equals(type)) {
                    BlockchainTaskHelper.disableJob((String)jobId);
                }
                TaskManageDao.updateStatus((String)taskBillNo, (String)"D");
            }
            catch (KDException e) {
                log.error("\u4e0a\u94fe\u4efb\u52a1\u505c\u6b62\u5931\u8d25\uff0c\u5806\u6808\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getStackTraceMessage());
                HashMap<String, Object> errorInfo = new HashMap<String, Object>();
                errorInfo.put("taskPkId", taskObject.getPkValue());
                errorInfo.put("taskBillNo", taskBillNo);
                errorInfo.put("errorMessage", e.getMessage());
                errorInfoList.add(errorInfo);
            }
        }
        return errorInfoList;
    }

    private boolean checkStcTaskStatusToStop(DynamicObject task, List<Map<String, Object>> errorInfoList) {
        String status = task.getString("billstatus");
        String taskBillNo = task.getString("billno");
        Long pkValue = (Long)task.getPkValue();
        if ("A".equals(status) || "B".equals(status)) {
            HashMap<String, Object> errorInfo = new HashMap<String, Object>();
            errorInfo.put("taskPkId", pkValue);
            errorInfo.put("taskBillNo", taskBillNo);
            errorInfo.put("errorMessage", ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5f00\u542f\u7684\u4efb\u52a1\u624d\u5141\u8bb8\u505c\u6b62\uff01", (String)"StcTaskServiceImpl_2", (String)"bsc-bea-mservice", (Object[])new Object[0]));
            errorInfoList.add(errorInfo);
            return false;
        }
        return true;
    }

    private void startEventTask(String billStatus, String taskBillNo, Map<String, Object> params) {
        if ("A".equals(billStatus) || "B".equals(billStatus)) {
            this.executeOnceToChain(params);
        }
        TaskManageDao.updateStatus((String)taskBillNo, (String)"C");
    }

    private void executeOnceToChain(Map<String, Object> params) {
        ThreadPools.executeOnce((String)"BSC-BEA-STC-TASK-EVENT-ONCE-RUNNABLE", () -> TaskUtil.toChain((Map)params));
    }

    private String getCronExpression(DynamicObject taskObject) {
        String type = taskObject.getString("type");
        if ("event_callback".equals(type)) {
            LocalDateTime taskDateTime = DateUtil.getCurrentDateTime().plusSeconds(30L);
            return String.format(ONCE_TASK_CRON_TEMPLATE, taskDateTime.getSecond(), taskDateTime.getMinute(), taskDateTime.getHour(), taskDateTime.getDayOfMonth(), taskDateTime.getMonth().getValue(), taskDateTime.getYear());
        }
        return taskObject.getString("cron");
    }

    private void createTaskAndRecord(String taskBillNo, String name, String cronExpression, Map<String, Object> params) {
        JobInfo jobInfo = BlockchainTaskHelper.prepareJobInfo((String)name, params);
        String jobId = BlockchainTaskHelper.createJob((JobInfo)jobInfo);
        PlanInfo planInfo = BlockchainTaskHelper.preparePlanInfo((String)taskBillNo, (String)jobId, (String)name, (String)cronExpression);
        String planId = BlockchainTaskHelper.createPlan((PlanInfo)planInfo);
        TaskManageDao.updateJobAndStatus((String)taskBillNo, (String)jobId, (String)planId, (String)"C");
    }

    private void enableTaskAndUpdate(String taskBillNo, String jobId) {
        BlockchainTaskHelper.enableJod((String)jobId);
        TaskManageDao.updateStatus((String)taskBillNo, (String)"C");
    }

    private String handleMappingsToPks(DynamicObject taskObject) {
        StringBuilder builder = new StringBuilder();
        DynamicObjectCollection mappings = taskObject.getDynamicObjectCollection("mappings");
        for (DynamicObject mappingObject : mappings) {
            Object basedataPkId = mappingObject.get("fbasedataid_id");
            builder.append(basedataPkId);
            builder.append(',');
        }
        return builder.toString();
    }

    private void updateRecordDate(String taskNo) {
        long currentNanos = DateUtil.getCurrentNanos();
        TaskManageDao.updateRecordDate((String)taskNo, (Long)currentNanos);
    }

    private static List<DynamicObject> queryBizModelData(DynamicObject mappingObj, String billNo) {
        Long mappingPkId = (Long)mappingObj.getPkValue();
        String mserviceParamJson = mappingObj.getString("stcc_custom_param");
        if (StringUtils.isNotBlank((CharSequence)mserviceParamJson)) {
            Object[] objParams = new Object[]{mappingPkId, null, billNo};
            MicroServiceParam customParam = (MicroServiceParam)JsonUtil.parse((String)mserviceParamJson, MicroServiceParam.class);
            if (StringUtils.isBlank((CharSequence)customParam.getCloudNumber())) {
                return (List)DispatchServiceHelper.invokeBOSService((String)customParam.getAppNumber(), (String)customParam.getServiceName(), (String)customParam.getMethodName(), (Object[])objParams);
            }
            return (List)DispatchServiceHelper.invokeBizService((String)customParam.getCloudNumber().toLowerCase(), (String)customParam.getAppNumber(), (String)customParam.getServiceName(), (String)customParam.getMethodName(), (Object[])objParams);
        }
        return BizModelDataQueryServiceHelper.query((Long)mappingPkId, null, (String)billNo);
    }
}

