/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.blink.util;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class BlinkUtil {
    private static final Log log = LogFactory.getLog(BlinkUtil.class);
    public static final String SYS_PROP_LOGIN_URL = "loginurl";
    private static final String ROOTURL = "https://kingdeeabc.com/blockchain-manager-backend/api/public/login-cangqiong";

    public static String getBlinkUrl() {
        Long orgId = RequestContext.get().getOrgId();
        String appId = AppMetadataCache.getAppInfo((String)"bcc").getId();
        String rootUrl = "";
        try {
            AppParam appParam = new AppParam(appId, orgId);
            rootUrl = String.valueOf(SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)SYS_PROP_LOGIN_URL));
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5e94\u7528\u53c2\u6570\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            rootUrl = ROOTURL;
        }
        if (StringUtils.isBlank((CharSequence)rootUrl)) {
            rootUrl = ROOTURL;
        }
        if (rootUrl.substring(rootUrl.length() - 1).equals("/")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        StringBuilder url = new StringBuilder();
        url.append(rootUrl);
        if (rootUrl.endsWith("/")) {
            url.replace(url.length() - 1, url.length(), "");
        }
        RequestContext context = RequestContext.get();
        String userId = context.getUserId();
        DynamicObject bosUser = QueryServiceHelper.queryOne((String)"bos_user", (String)"name,phone,username", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(userId)).toArray());
        String phone = BlinkUtil.getValue(bosUser, "phone");
        String showName = BlinkUtil.getValue(bosUser, "name");
        String username = BlinkUtil.getValue(bosUser, "username");
        String tenantId = context.getTenantId();
        String tenantName = context.getTenantInfo().getName();
        String accountId = context.getAccountId();
        String accountName = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId).getAccountName();
        String clientFullContextPath = context.getClientFullContextPath();
        url.append('?');
        url.append("userId=").append(userId).append('&');
        url.append("userName=").append(username).append('&');
        url.append("showName=").append(showName).append('&');
        url.append("phone=").append(phone).append('&');
        url.append("accountId=").append(accountId).append('&');
        url.append("accountName=").append(accountName).append('&');
        url.append("tenantId=").append(tenantId).append('&');
        url.append("tenantName=").append(tenantName).append('&');
        url.append("url=").append(clientFullContextPath);
        return url.toString();
    }

    public static String getValue(DynamicObject obj, String key) {
        String value = obj.getString(key);
        return value == null ? "" : value;
    }
}

