/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.util.StringUtils;
import kd.data.eci.formplugin.ECIBasePlugin;
import kd.data.eci.model.GSSFReportApiResult;

public class ECIAppHomeHistoryCardPlugin
extends ECIBasePlugin {
    private static final Log log = LogFactory.getLog(ECIAppHomeHistoryCardPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().beginInit();
        try {
            this.loadHistoryData();
        }
        finally {
            this.getModel().endInit();
        }
        this.getAppPageCache().put("AppHomeHistoryCardPageId", this.getView().getPageId());
    }

    private void loadHistoryData() {
        DynamicObjectCollection collection;
        this.getModel().deleteEntryData("history_list");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"eci_oplog");
        IUserService userService = (IUserService)this.getView().getService(IUserService.class);
        ArrayList qFilters = null;
        try {
            qFilters = PermissionFilterUtil.getListPermissionFilters((MainEntityType)mainEntityType, (boolean)true, (String)"eci", null, (IUserService)userService);
        }
        catch (Exception ex) {
            log.warn("getListPermissionFilters error!", (Throwable)ex);
        }
        if (qFilters == null) {
            qFilters = new ArrayList(1);
        }
        if (!(collection = ORM.create().query("eci_oplog", "id,company_name,report_number,report_status,credit_code,createdate", qFilters.toArray(new QFilter[0]), "createdate desc", 7)).isEmpty()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            int size = collection.size();
            if (size > 6) {
                size = 6;
            }
            this.getModel().batchCreateNewEntryRow("history_list", size);
            for (int index = 0; index < size; ++index) {
                DynamicObject object = (DynamicObject)collection.get(index);
                this.getModel().setValue("company_name", (Object)object.getString("company_name"), index);
                this.getModel().setValue("report_number", (Object)object.getString("report_number"), index);
                this.getModel().setValue("credit_code", (Object)object.getString("credit_code"), index);
                this.getModel().setValue("last_view_time", (Object)sdf.format(object.getDate("createdate")), index);
                this.getModel().setValue("report_status", (Object)" ", index);
            }
        }
        this.getView().setVisible(Boolean.valueOf(collection.size() > 6), new String[]{"more"});
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"refresh", "more"});
        CardEntry historyList = (CardEntry)this.getControl("history_list");
        historyList.addRowClickListener(new RowClickEventListener(){

            public void entryRowDoubleClick(RowClickEvent evt) {
                ECIAppHomeHistoryCardPlugin.this.openReport(evt.getRow());
            }

            public void entryRowClick(RowClickEvent evt) {
                ECIAppHomeHistoryCardPlugin.this.openReport(evt.getRow());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openReport(int rowIndex) {
        this.getView().showLoading(null);
        try {
            DynamicObject item = this.getModel().getEntryRowEntity("history_list", rowIndex);
            String companyName = item.getString("company_name");
            String creditCode = item.getString("credit_code");
            String reportNumber = item.getString("report_number");
            GSSFReportApiResult result = null;
            try {
                result = this.eciService.findGSSFReportByReportId(reportNumber);
            }
            catch (Exception ex) {
                this.eciService.handleException(ex);
                this.getView().hideLoading();
                return;
            }
            if (result == null || StringUtils.isEmpty((String)result.getIframeUrl())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6253\u5f00\u62a5\u544a\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5", (String)"ECIAppHomeHistoryCardPlugin_0", (String)"data-eci-formplugin", (Object[])new Object[0]));
                return;
            }
            this.eciService.showReport(companyName, creditCode, result);
        }
        finally {
            this.getView().hideLoading();
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("refresh".equals(key)) {
            this.loadHistoryData();
        } else if ("more".equals(key)) {
            String formId = "eci_oplog";
            List menus = AppMetadataCache.getAppMenusInfoByAppId((String)"eci");
            AppMenuInfo foundMenuInfo = null;
            if (menus != null) {
                for (AppMenuInfo menuInfo : menus) {
                    if (!formId.equals(menuInfo.getFormId())) continue;
                    foundMenuInfo = menuInfo;
                    break;
                }
            }
            String mainViewPageId = this.getMainViewPageId();
            if (foundMenuInfo == null || StringUtils.isEmpty((String)mainViewPageId)) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setBillFormId(formId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                String pageId = foundMenuInfo.getId() + mainViewPageId;
                String appPageId = "eci" + mainViewPageId;
                IFormView searchPageView = this.getView().getViewNoPlugin(pageId);
                if (searchPageView == null) {
                    ListShowParameter showParameter = new ListShowParameter();
                    showParameter.setBillFormId(formId);
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setPageId(pageId);
                    showParameter.setParentPageId(appPageId);
                    this.getView().showForm((FormShowParameter)showParameter);
                } else {
                    searchPageView.activate();
                    this.getView().sendFormAction(searchPageView);
                }
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("refresh_background".equals(e.getName())) {
            try {
                this.loadHistoryData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

