/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.formplugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.data.eci.formplugin.ECIBasePlugin;

public class ECIAppHomeQuickSearchCardPlugin
extends ECIBasePlugin {
    private static final Log log = LogFactory.getLog(ECIAppHomeQuickSearchCardPlugin.class);

    public void registerListener(EventObject event) {
        super.registerListener(event);
        final Search search = (Search)this.getControl("searchap");
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent searchEnterEvent) {
                search.setSearchKey(searchEnterEvent.getText());
                ECIAppHomeQuickSearchCardPlugin.this.showSearchPage(searchEnterEvent.getText());
            }

            public List<String> getSearchList(SearchEnterEvent evt) {
                if (StringUtils.isEmpty((String)evt.getText())) {
                    return Collections.emptyList();
                }
                try {
                    return ECIAppHomeQuickSearchCardPlugin.this.eciService.qyList(evt.getText());
                }
                catch (Exception ignore) {
                    return Collections.emptyList();
                }
            }
        });
        this.addClickListeners(new String[]{"btn_search"});
    }

    private void showSearchPage(String s) {
        if (StringUtils.isEmpty((String)s)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u641c\u7d22\u7684\u4f01\u4e1a\u540d", (String)"ECIAppHomeQuickSearchCardPlugin_0", (String)"data-eci-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = "eci_company_search";
        List menus = AppMetadataCache.getAppMenusInfoByAppId((String)"eci");
        AppMenuInfo foundMenuInfo = null;
        if (menus != null) {
            for (AppMenuInfo menuInfo : menus) {
                if (!formId.equals(menuInfo.getFormId())) continue;
                foundMenuInfo = menuInfo;
                break;
            }
        }
        String mainViewPageId = this.getMainViewPageId();
        if (foundMenuInfo == null || StringUtils.isEmpty((String)mainViewPageId)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("keyword", (Object)s);
            this.getView().showForm(showParameter);
        } else {
            String pageId = foundMenuInfo.getId() + mainViewPageId;
            String appPageId = "eci" + mainViewPageId;
            IFormView searchPageView = this.getView().getViewNoPlugin(pageId);
            if (searchPageView == null) {
                this.newSearchPage(appPageId, pageId, s);
            } else {
                this.updateSearchPage(searchPageView, s);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("btn_search".equals(key)) {
            Search search = (Search)this.getControl("searchap");
            this.showSearchPage(search.getSearchKey());
        }
    }
}

