/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.events.ClientCallBackEvent;
import kd.data.eci.formplugin.ECIBasePlugin;
import kd.data.eci.model.BalanceInfo;
import kd.data.eci.model.ECIConfigInfo;

public class ECIAppHomeStatusCardPlugin
extends ECIBasePlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Label remainLabel = (Label)this.getControl("remain_label");
        remainLabel.setText("");
        Label totalLabel = (Label)this.getControl("total_label");
        totalLabel.setText("");
        this.getView().setVisible(Boolean.FALSE, new String[]{"split_label", "report_type_label"});
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.setPercent(0);
        this.getView().showLoading(null);
        this.getView().addClientCallBack("initLoadData", Integer.valueOf(1000));
        this.getAppPageCache().put("AppHomeStatusCardPageId", this.getView().getPageId());
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
    }

    private int refreshData() {
        int remainBalance = 0;
        int totalBalance = 0;
        BalanceInfo balance = this.eciService.getBalance();
        if (balance != null) {
            remainBalance = balance.getBalance();
            if (remainBalance == 0) {
                remainBalance = balance.getTestBalance();
            }
            totalBalance = balance.getTotalBalance();
        }
        Label remainLabel = (Label)this.getControl("remain_label");
        remainLabel.setText(String.valueOf(remainBalance));
        Label totalLabel = (Label)this.getControl("total_label");
        totalLabel.setText(String.valueOf(totalBalance));
        if (totalBalance == 0) {
            return 0;
        }
        return remainBalance * 100 / totalBalance;
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"refresh", "content"});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("refresh".equals(key)) {
            try {
                this.refresh();
            }
            catch (Exception ex) {
                this.eciService.handleException(ex);
            }
        }
    }

    private void refresh() {
        ECIConfigInfo eciConfig = this.eciService.getCustomerConfigInfo();
        if (eciConfig == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u5ba2\u6237\u4fe1\u606f", (String)"ECIAppHomeStatusCardPlugin_0", (String)"data-eci-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"split_label", "report_type_label"});
            Label remainLabel = (Label)this.getControl("company_id_label");
            remainLabel.setText(eciConfig.getClientId());
            int percent = this.refreshData();
            ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
            progressbar.setPercent(percent);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("initLoadData".equals(e.getName())) {
            this.eciService.checkInitLock();
            try {
                this.refresh();
            }
            catch (Exception ex) {
                this.eciService.handleException(ex);
            }
            this.getView().hideLoading();
        } else if ("refresh_background".equals(e.getName())) {
            try {
                this.refresh();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

