/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.formplugin;

import kd.bos.bill.OperationStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.util.StringUtils;
import kd.data.eci.formplugin.ECIPluginService;

public class ECIBasePlugin
extends AbstractFormPlugin {
    protected ECIPluginService eciService = null;

    public void initialize() {
        super.initialize();
        this.eciService = new ECIPluginService();
        this.eciService.setFormView(this.getView());
        this.eciService.init();
    }

    protected String getMainViewPageId() {
        String mainPageId;
        String rootPageId = this.getView().getFormShowParameter().getRootPageId();
        SessionManager sessionManager = SessionManager.getCurrent();
        return sessionManager.existView(mainPageId = sessionManager.getMainPageId(rootPageId)) ? mainPageId : null;
    }

    protected IPageCache getAppPageCache() {
        String mainViewPageId = this.getMainViewPageId();
        if (StringUtils.isNotEmpty((String)mainViewPageId)) {
            String appPageId = "eci" + mainViewPageId;
            IFormView appPageView = this.getView().getViewNoPlugin(appPageId);
            if (appPageView != null) {
                return (IPageCache)appPageView.getService(IPageCache.class);
            }
        }
        return this.getPageCache();
    }

    protected void notifyStatusCardChange() {
        IFormView statusCardFormView;
        String statusCardPageId = this.getAppPageCache().get("AppHomeStatusCardPageId");
        if (StringUtils.isNotEmpty((String)statusCardPageId) && (statusCardFormView = this.getView().getViewNoPlugin(statusCardPageId)) != null) {
            statusCardFormView.addClientCallBack("refresh_background");
            this.getView().sendFormAction(statusCardFormView);
        }
    }

    protected void notifyHistoryCardChange() {
        IFormView historyCardFormView;
        String historyCardPageId = this.getAppPageCache().get("AppHomeHistoryCardPageId");
        if (StringUtils.isNotEmpty((String)historyCardPageId) && (historyCardFormView = this.getView().getViewNoPlugin(historyCardPageId)) != null) {
            historyCardFormView.addClientCallBack("refresh_background");
            this.getView().sendFormAction(historyCardFormView);
        }
    }

    protected void showConfirm(String msg, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eci_dialog");
        showParameter.setCustomParam("msg", (Object)msg);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    protected void newSearchPage(String appPageId, String pageId, String s) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId("eci_company_search");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("keyword", (Object)s);
        showParameter.setPageId(pageId);
        showParameter.setParentPageId(appPageId);
        this.getView().showForm(showParameter);
    }

    protected void updateSearchPage(IFormView searchPageView, String s) {
        searchPageView.activate();
        IPageCache searchPageViewPageCache = (IPageCache)searchPageView.getService(IPageCache.class);
        searchPageViewPageCache.putBigObject("eci_search_company", s);
        searchPageView.addClientCallBack("update_keyword", Integer.valueOf(200));
        this.getView().sendFormAction(searchPageView);
    }
}

