/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.formplugin;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.eci.formplugin.ECIPluginService;
import kd.data.eci.model.GSSFReportApiResult;

public class ECIHistoryListPlugin
extends AbstractListPlugin {
    protected ECIPluginService eciService = null;

    public void initialize() {
        super.initialize();
        this.eciService = new ECIPluginService();
        this.eciService.setFormView(this.getView());
        this.eciService.init();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator);
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (userId.equals(10L)) {
            isSuperAdmin = true;
        }
        if (!isAdmin && !isSuperAdmin) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"delete"});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        GSSFReportApiResult result;
        args.setCancel(true);
        BillList billlist = (BillList)this.getControl("billlistap");
        Long id = (Long)billlist.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        billlist.clearSelection();
        billlist.selectRows(args.getRowIndex(), true);
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eci_oplog");
        String companyName = item.getString("company_name");
        String creditCode = item.getString("credit_code");
        String reportNumber = item.getString("report_number");
        try {
            result = this.eciService.findGSSFReportByReportId(reportNumber);
        }
        catch (Exception ex) {
            this.eciService.handleException(ex);
            return;
        }
        if (result == null || StringUtils.isEmpty((String)result.getIframeUrl())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6253\u5f00\u62a5\u544a\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5", (String)"ECIHistoryListPlugin_0", (String)"data-eci-formplugin", (Object[])new Object[0]));
            return;
        }
        this.eciService.showReport(companyName, creditCode, result);
    }
}

