/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;
import kd.data.eci.core.BigDataXYClient;
import kd.data.eci.model.BalanceInfo;
import kd.data.eci.model.CheckReportApiResult;
import kd.data.eci.model.CompanySearchApiResult;
import kd.data.eci.model.ECIConfigInfo;
import kd.data.eci.model.GSSFDownloadUrlInfo;
import kd.data.eci.model.GSSFReportApiResult;
import kd.data.eci.model.RequestCustomer;
import kd.data.eci.util.CipherMd5;

public class ECIPluginService {
    private static final Log log = LogFactory.getLog(ECIPluginService.class);
    private final BigDataXYClient client = new BigDataXYClient();
    private final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("data-eci");
    private RequestCustomer requestCustomer;
    private ECIConfigInfo customerConfigInfo;
    private IFormView formView;
    private String cacheKey = "";

    ECIPluginService() {
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public RequestCustomer getRequestCustomer() {
        if (this.requestCustomer == null) {
            this.updateCurrentRequestCompany();
        }
        return this.requestCustomer;
    }

    public ECIConfigInfo getCustomerConfigInfo() {
        if (this.customerConfigInfo == null) {
            this.initCustomerConfigInfoFromCache();
            if (this.customerConfigInfo == null) {
                try {
                    this.updateCustomerConfigFromApi();
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex);
                }
            }
        }
        return this.customerConfigInfo;
    }

    public void init() {
        this.initRequestCustomer();
        this.initCustomerConfigInfoFromCache();
    }

    private void initRequestCustomer() {
        String key = this.getCustomerConfigCacheKey();
        String s = (String)this.cache.get(key + "_request_company");
        if (StringUtils.isNotEmpty((String)s)) {
            try {
                this.requestCustomer = (RequestCustomer)JSON.parseObject((String)s, RequestCustomer.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.requestCustomer == null) {
            this.updateCurrentRequestCompany();
        }
    }

    private void initCustomerConfigInfoFromCache() {
        String key = this.getCustomerConfigCacheKey();
        String s = (String)this.cache.get(key);
        if (StringUtils.isNotEmpty((String)s)) {
            try {
                this.customerConfigInfo = (ECIConfigInfo)JSON.parseObject((String)s, ECIConfigInfo.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateCurrentRequestCompany() {
        String key = this.getCustomerConfigCacheKey();
        Map productInfo = LicenseServiceHelper.getProductInfo();
        String companyId = (String)productInfo.get("productID") + (String)productInfo.get("productNo") + (String)productInfo.get("prodInstCode");
        companyId = CipherMd5.encrypt((String)companyId);
        String tenantId = RequestContext.get().getTenantId();
        TenantInfo tenantInfo = AccountUtils.getTenantByid((String)tenantId);
        this.requestCustomer = new RequestCustomer();
        this.requestCustomer.setCosmicCompanyId(companyId);
        this.requestCustomer.setCosmicProduct(String.valueOf(productInfo.get("productID")));
        this.requestCustomer.setCosmicProductNo(String.valueOf(productInfo.get("productNo")));
        this.requestCustomer.setProdInstCode(String.valueOf(productInfo.get("prodInstCode")));
        this.requestCustomer.setCompanyName(tenantInfo == null ? "" : tenantInfo.getName());
        this.requestCustomer.setTenantId(tenantId);
        this.requestCustomer.setProdType(String.valueOf(productInfo.get("type")));
        this.cache.put(key + "_request_company", (Object)JSON.toJSONString((Object)this.requestCustomer));
    }

    private String getCustomerConfigCacheKey() {
        if (StringUtils.isEmpty((String)this.cacheKey)) {
            String tenantId = RequestContext.get().getTenantId();
            String accountId = RequestContext.get().getAccountId();
            this.cacheKey = "eci_config_" + tenantId + "_" + accountId;
        }
        return this.cacheKey;
    }

    public void updateCustomerConfigWithLock() {
        String key = this.getCustomerConfigCacheKey();
        try (DLock lock = DLock.create((String)("data/eci/init-tenant-config/" + key)).fastMode();){
            if (lock.tryLock()) {
                try {
                    this.updateCustomerConfigFromApi();
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex);
                }
            }
        }
    }

    private BigDataXYClient getClient() {
        IPageCache pageCache;
        String clazz;
        if (this.formView != null && StringUtils.isNotEmpty((String)(clazz = (pageCache = this.formView.getPageCache()).get("custom_big_data_xy_client_class")))) {
            try {
                return (BigDataXYClient)TypesContainer.createInstance((String)clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.client;
    }

    private void updateCustomerConfigFromApi() throws Exception {
        String key = this.getCustomerConfigCacheKey();
        ECIConfigInfo eciConfig = this.getClient().getCompanyConfigInfo(this.getRequestCustomer());
        if (eciConfig != null) {
            this.customerConfigInfo = eciConfig;
            String s = JSON.toJSONString((Object)eciConfig);
            this.cache.put(key, (Object)s);
        }
    }

    public void checkInitLock() {
        String key = this.getCustomerConfigCacheKey();
        try (DLock lock = DLock.create((String)("data/eci/init-tenant-config/" + key)).fastMode();){
            lock.tryLock(5000L);
        }
    }

    public BalanceInfo getBalance() {
        RequestCustomer requestCustomer = this.getRequestCustomer();
        try {
            BalanceInfo balance;
            IPageCache pageCache;
            if (requestCustomer != null && "2".equals(requestCustomer.getProdType()) && this.formView != null && !"true".equals((pageCache = this.formView.getPageCache()).get("eci_temp_lic_log"))) {
                log.info("Temp License: " + JSON.toJSONString((Object)requestCustomer));
                pageCache.put("eci_temp_lic_log", "true");
            }
            if ((balance = this.getClient().getCustomerBalance(requestCustomer)) != null) {
                String key = this.getCustomerConfigCacheKey();
                this.cache.put(key + "_customer_balance", (Object)JSON.toJSONString((Object)balance));
            }
            return balance;
        }
        catch (Exception ex) {
            throw new KDException(new ErrorCode("eci_get_balance_error", ResManager.loadKDString((String)"\u83b7\u53d6\u8ba2\u9605\u4fe1\u606f\u5931\u8d25", (String)"ECIPluginService_0", (String)"data-eci-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    public BalanceInfo getBalanceFromCache() {
        String key = this.getCustomerConfigCacheKey();
        String s = (String)this.cache.get(key + "_customer_balance");
        if (StringUtils.isNotEmpty((String)s)) {
            try {
                return (BalanceInfo)JSON.parseObject((String)s, BalanceInfo.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getBalance();
    }

    public List<String> qyList(String keyword) {
        if (StringUtils.isEmpty((String)keyword)) {
            return Collections.emptyList();
        }
        try {
            return this.getClient().qyList(keyword);
        }
        catch (KDException ex) {
            log.warn((Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return Collections.emptyList();
        }
    }

    public CompanySearchApiResult searchCompany(String keyword, Map<String, String> filter, int skip) {
        if (StringUtils.isEmpty((String)keyword)) {
            return new CompanySearchApiResult();
        }
        try {
            return this.getClient().searchCompany(keyword, filter, skip);
        }
        catch (KDException ex) {
            log.warn((Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return new CompanySearchApiResult();
        }
    }

    public CheckReportApiResult checkCustomerReport(String keyword) {
        try {
            return this.getClient().checkCustomerReport(this.getRequestCustomer(), keyword);
        }
        catch (KDException ex) {
            log.warn((Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return null;
        }
    }

    public GSSFReportApiResult findGSSFReportByKeyWord(String keyword) {
        ECIConfigInfo config = this.getCustomerConfigInfo();
        if (config == null) {
            throw new KDException(new ErrorCode("eci_no_tenant_config", ResManager.loadKDString((String)"\u6ca1\u6709\u5ba2\u6237\u4fe1\u606f", (String)"ECIPluginService_1", (String)"data-eci-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        try {
            return this.getClient().findGSSFReportByKeyWord(config, this.getRequestCustomer(), keyword);
        }
        catch (KDException ex) {
            log.warn((Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return null;
        }
    }

    public GSSFReportApiResult findGSSFReportByReportId(String reportId) {
        ECIConfigInfo config = this.getCustomerConfigInfo();
        if (config == null) {
            throw new KDException(new ErrorCode("eci_no_tenant_config", ResManager.loadKDString((String)"\u6ca1\u6709\u5ba2\u6237\u4fe1\u606f", (String)"ECIPluginService_1", (String)"data-eci-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        try {
            return this.getClient().findGSSFReportByReportId(config, this.getRequestCustomer(), reportId);
        }
        catch (KDException ex) {
            log.warn((Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return null;
        }
    }

    public GSSFDownloadUrlInfo findGSSFDownloadUrl(String reportId) {
        try {
            return this.getClient().findGSSFDownloadUrl(reportId);
        }
        catch (KDException ex) {
            log.warn((Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return null;
        }
    }

    public boolean sendGSSFToEmail(String reportId, String email) {
        try {
            return this.getClient().sendGSSFToEmail(reportId, email);
        }
        catch (KDException ex) {
            log.warn((Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.warn((Throwable)ex);
            return false;
        }
    }

    public void handleException(Exception ex) {
        if (ex instanceof KDException) {
            KDException kdex = (KDException)((Object)ex);
            if (kdex.getErrorCode() != null && "eci_result_210".equals(kdex.getErrorCode().getCode())) {
                this.showSubscriptionNotify(null);
            } else {
                if (StringUtils.isEmpty((String)kdex.getMessage()) || this.formView == null) {
                    throw kdex;
                }
                this.formView.showMessage(kdex.getMessage());
            }
        } else {
            log.warn((Throwable)ex);
        }
    }

    public void showSubscriptionNotify(BalanceInfo balance) {
        String formId = "eci_no_balance_dialog";
        if (MetadataDao.checkNumber((String)formId)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.formView.showForm(showParameter);
        } else {
            this.formView.showMessage(ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u60a8\u7684\u989d\u5ea6\u5df2\u7528\u5b8c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u8ba2\u9605", (String)"ECIPluginService_2", (String)"data-eci-formplugin", (Object[])new Object[0]));
        }
    }

    protected void showReport(String companyName, String companyCreditCode, GSSFReportApiResult result) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId("eci_report");
        showParameter.setCaption(companyName + ResManager.loadKDString((String)"\u7684\u5de5\u5546\u53f8\u6cd5\u62a5\u544a", (String)"ECIPluginService_3", (String)"data-eci-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("company_name", (Object)companyName);
        showParameter.setCustomParam("company_credit_code", (Object)companyCreditCode);
        showParameter.setCustomParam("report_id", (Object)result.getReportId());
        showParameter.setCustomParam("report_url", (Object)result.getIframeUrl());
        this.formView.showForm(showParameter);
    }
}

