/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.util.StringUtils;
import kd.data.eci.core.ECIOpLog;
import kd.data.eci.formplugin.ECIBasePlugin;
import kd.data.eci.model.BalanceInfo;
import kd.data.eci.model.GSSFDownloadUrlInfo;
import kd.data.eci.model.GSSFReportApiResult;

public class ECIReportFormPlugin
extends ECIBasePlugin {
    private static final Log log = LogFactory.getLog(ECIReportFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String reportUrl = (String)this.getView().getFormShowParameter().getCustomParam("report_url");
        if (StringUtils.isEmpty((String)reportUrl)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u62a5\u544a\u6570\u636e", (String)"ECIReportFormPlugin_0", (String)"data-eci-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"download", "refresh", "iframeap"});
            return;
        }
        ((IFrame)this.getControl("iframeap")).setSrc(reportUrl);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("refresh".equals(evt.getOperationKey())) {
            BalanceInfo balance = null;
            try {
                balance = this.eciService.getBalanceFromCache();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (balance != null && balance.getBalance() + balance.getTestBalance() <= 0) {
                this.eciService.showSubscriptionNotify(balance);
                this.notifyStatusCardChange();
            } else if ("true".equals(SessionManager.getCurrent().get("eci_refresh_confirm_no_show_next_time"))) {
                this.getView().addClientCallBack("refresh");
                log.debug("refresh report without confirm");
            } else {
                this.showConfirm(ResManager.loadKDString((String)"\u66f4\u65b0\u62a5\u544a\u9700\u6263\u51cf1\u6b21\u67e5\u8be2\u989d\u5ea6\uff0c\u786e\u5b9a\u8981\u66f4\u65b0\u62a5\u544a\u5417\uff1f", (String)"ECIReportFormPlugin_1", (String)"data-eci-formplugin", (Object[])new Object[0]), new CloseCallBack((IFormPlugin)this, "refresh"));
                log.debug("refresh report with confirm");
            }
        } else if ("download".equals(evt.getOperationKey())) {
            this.getView().showLoading(ResManager.getLocaleString((String)"\u83b7\u53d6\u4e0b\u8f7d\u5730\u5740\u4e2d", (String)"ECIReportFormPlugin_6", (String)"data-eci-formplugin"));
            boolean b = this.checkDownloadUrl();
            if (b) {
                this.getView().addClientCallBack("check_download_url", Integer.valueOf(3000));
            } else {
                this.getView().hideLoading();
            }
        } else if ("send_to_email".equals(evt.getOperationKey())) {
            this.getPageCache().put("input_email", "");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eci_send_report_to_email");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "input_email"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private boolean checkDownloadUrl() {
        boolean checkNext = false;
        try {
            String reportId = this.getCurrentReportId();
            GSSFDownloadUrlInfo downloadUrl = this.eciService.findGSSFDownloadUrl(reportId);
            if (downloadUrl == null || downloadUrl.getStatus() == 500) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ECIReportFormPlugin_2", (String)"data-eci-formplugin", (Object[])new Object[0]));
            } else if (downloadUrl.getStatus() == 445) {
                checkNext = true;
            } else if (StringUtils.isNotEmpty((String)downloadUrl.getPdfUrl())) {
                this.getView().download(downloadUrl.getPdfUrl());
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"ECIReportFormPlugin_2", (String)"data-eci-formplugin", (Object[])new Object[0]));
            }
        }
        catch (KDException ex) {
            this.eciService.handleException((Exception)((Object)ex));
        }
        return checkNext;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject returnObj;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("input_email".equals(actionId)) {
            if (StringUtils.isNotEmpty((String)returnData)) {
                this.getPageCache().put("input_email", returnData);
                this.getView().addClientCallBack("send_to_email");
            }
        } else if ("refresh".equals(actionId) && StringUtils.isNotEmpty((String)returnData) && "ok".equals((returnObj = JSON.parseObject((String)returnData)).getString("result"))) {
            if (returnObj.getBooleanValue("no_show_next_time")) {
                SessionManager.getCurrent().put("eci_refresh_confirm_no_show_next_time", "true");
            }
            this.getView().addClientCallBack("refresh");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientCallBack(ClientCallBackEvent e) {
        if ("send_to_email".equals(e.getName())) {
            String email = this.getPageCache().get("input_email");
            this.getView().showLoading(ResManager.getLocaleString((String)"\u53d1\u9001\u90ae\u4ef6\u4e2d", (String)"ECIReportFormPlugin_7", (String)"data-eci-formplugin"));
            try {
                String reportId = this.getCurrentReportId();
                boolean result = this.eciService.sendGSSFToEmail(reportId, email);
                if (result) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"ECIReportFormPlugin_3", (String)"data-eci-formplugin", (Object[])new Object[0]));
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25", (String)"ECIReportFormPlugin_4", (String)"data-eci-formplugin", (Object[])new Object[0]));
            }
            catch (KDException ex) {
                this.eciService.handleException((Exception)((Object)ex));
            }
            finally {
                this.getView().hideLoading();
            }
        } else if ("refresh".equals(e.getName())) {
            this.getView().showLoading(null);
            try {
                this.refreshReport();
            }
            catch (KDException ex) {
                this.eciService.handleException((Exception)((Object)ex));
            }
            finally {
                this.getView().hideLoading();
            }
        } else if ("check_download_url".equals(e.getName())) {
            boolean b = this.checkDownloadUrl();
            if (b) {
                this.getView().addClientCallBack("check_download_url", Integer.valueOf(3000));
            } else {
                this.getView().hideLoading();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshReport() {
        String reportId = this.getCurrentReportId();
        String companyName = (String)this.getView().getFormShowParameter().getCustomParam("company_name");
        String companyCreditCode = (String)this.getView().getFormShowParameter().getCustomParam("company_credit_code");
        if (StringUtils.isNotEmpty((String)companyName)) {
            try {
                GSSFReportApiResult report = this.eciService.findGSSFReportByKeyWord(companyName);
                if (report != null && StringUtils.isNotEmpty((String)report.getReportId())) {
                    if (!Objects.equals(reportId, report.getReportId())) {
                        this.getPageCache().put("report_id", report.getReportId());
                        ECIOpLog.add((String)"view_report", (String)companyName, (String)report.getReportId(), (String)companyCreditCode, (boolean)report.isDeduction());
                        this.notifyHistoryCardChange();
                    }
                    ((IFrame)this.getControl("iframeap")).setSrc(report.getIframeUrl());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u83b7\u53d6\u6700\u65b0\u62a5\u544a", (String)"ECIReportFormPlugin_5", (String)"data-eci-formplugin", (Object[])new Object[0]));
                }
            }
            finally {
                this.notifyStatusCardChange();
            }
        }
    }

    private String getCurrentReportId() {
        String reportId = this.getPageCache().get("report_id");
        if (StringUtils.isEmpty((String)reportId)) {
            reportId = (String)this.getView().getFormShowParameter().getCustomParam("report_id");
        }
        return reportId;
    }
}

