/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.KDException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.util.StringUtils;
import kd.data.eci.formplugin.ECIPluginService;
import kd.data.eci.model.CompanyInfo;
import kd.data.eci.model.CompanySearchApiResult;

public class ECISearchResultDataProvider
extends ListDataProvider {
    private static final Log log = LogFactory.getLog(ECISearchResultDataProvider.class);
    private final DynamicObjectType dot = DataCacheReader.get().getDataEntityType("eci_company");
    private IFormView formView;
    private IPageCache pageCache;
    private ECIPluginService eciService;
    private CompanySearchApiResult searchResult;
    private Map<String, Object> searchValueMap;

    ECISearchResultDataProvider() {
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
        this.pageCache = (IPageCache)formView.getService(IPageCache.class);
        FilterContainer filterContainer = (FilterContainer)formView.getControl("filtercontainerap");
        filterContainer.addSearchClickListener(evt -> {
            this.searchValueMap = new HashMap<String, Object>(4);
            this.searchValueMap.put("region", evt.getFilterValue("region"));
            this.searchValueMap.put("capital", evt.getFilterValue("capital"));
            this.searchValueMap.put("status", evt.getFilterValue("status"));
            this.searchValueMap.put("company_type", evt.getFilterValue("company_type"));
        });
    }

    public void setEciService(ECIPluginService eciService) {
        this.eciService = eciService;
    }

    public String getKeyword() {
        return this.pageCache.getBigObject("eci_search_company");
    }

    public Map<String, String> getFilter() {
        Object companyType;
        Object status;
        Object capital;
        Object region;
        FilterContainer filterContainer = (FilterContainer)this.formView.getControl("filtercontainerap");
        HashMap<String, String> rtn = new HashMap<String, String>(4);
        if (this.searchValueMap == null) {
            this.searchValueMap = new HashMap<String, Object>();
        }
        if ((region = this.searchValueMap.get("region")) != null) {
            rtn.put("region", String.valueOf(region));
        }
        if ((capital = this.searchValueMap.get("capital")) != null) {
            rtn.put("capital", String.valueOf(capital));
        }
        if ((status = this.searchValueMap.get("status")) != null) {
            rtn.put("status", String.valueOf(status));
        }
        if ((companyType = this.searchValueMap.get("company_type")) != null) {
            rtn.put("companyType", String.valueOf(companyType));
        }
        return rtn;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        try {
            this.searchResult = this.eciService.searchCompany(this.getKeyword(), this.getFilter(), start);
        }
        catch (KDException ex) {
            this.eciService.handleException((Exception)((Object)ex));
        }
        if (this.searchResult == null || this.searchResult.getNum() == 0 || this.searchResult.getItems() == null) {
            return new DynamicObjectCollection(this.dot, null);
        }
        DynamicObjectCollection doc = new DynamicObjectCollection(this.dot, null);
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds("eci_company", this.searchResult.getItems().size());
        int i = 0;
        HashMap<String, CompanyInfo> cacheSearchResult = new HashMap<String, CompanyInfo>(this.searchResult.getNum());
        String cacheResult = this.pageCache.getBigObject("eci_search_result");
        if (StringUtils.isNotEmpty((String)cacheResult)) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)cacheResult);
                cacheSearchResult.putAll((Map<String, CompanyInfo>)jsonObject);
            }
            catch (Exception jsonObject) {
                // empty catch block
            }
        }
        for (CompanyInfo companyInfo : this.searchResult.getItems()) {
            long id = ids[i++];
            DynamicObject object = new DynamicObject(this.dot, (Object)id);
            object.set("name", (Object)companyInfo.getName());
            object.set("oper_name", (Object)companyInfo.getOperName());
            object.set("credit_code", (Object)companyInfo.getCreditCode());
            object.set("regno", (Object)companyInfo.getRegNo());
            object.set("start_date", (Object)companyInfo.getStartDate());
            doc.add((Object)object);
            cacheSearchResult.put(String.valueOf(start + i), companyInfo);
        }
        this.pageCache.putBigObject("eci_search_result", JSON.toJSONString(cacheSearchResult));
        return doc;
    }

    public QueryResult getQueryResult() {
        QueryResult queryResult = new QueryResult();
        if (this.searchResult != null) {
            queryResult.setBillDataCount(this.searchResult.getTotal());
            queryResult.setDataCount(this.searchResult.getTotal());
        }
        return queryResult;
    }

    public int getRealCount() {
        return this.searchResult != null ? this.searchResult.getTotal() : 0;
    }

    public int getBillDataCount() {
        return this.searchResult != null ? this.searchResult.getTotal() : 0;
    }
}

