/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.util.StringUtils;
import kd.data.eci.core.ECIOpLog;
import kd.data.eci.formplugin.ECIBasePlugin;
import kd.data.eci.formplugin.ECISearchResultDataProvider;
import kd.data.eci.model.BalanceInfo;
import kd.data.eci.model.CheckReportApiResult;
import kd.data.eci.model.CompanyInfo;
import kd.data.eci.model.GSSFReportApiResult;

public class ECISearchResultFormPlugin
extends ECIBasePlugin {
    private static final Log log = LogFactory.getLog(ECISearchResultFormPlugin.class);
    private static final String KEY_SEARCHAP = "searchap";
    private static final String KEY_BILLLISTAP = "billlistap";
    private static final String KEY_FILTERCONTAINERAP = "filtercontainerap";
    private static final String KEY_FLEXPANELAP = "flexpanelap1";
    protected ECISearchResultDataProvider dataProvider = new ECISearchResultDataProvider();

    @Override
    public void initialize() {
        super.initialize();
        this.dataProvider.setFormView(this.getView());
        this.dataProvider.setEciService(this.eciService);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        billList.setEntityId("eci_company");
        billList.addCreateListDataProviderListener(args -> args.setListDataProvider((IListDataProvider)this.dataProvider));
        billList.addAfterBindDataListener(evt -> {
            int i = billList.queryBillDataCount();
            ((Label)this.getControl("found_num_label")).setText(String.valueOf(i));
        });
        FilterContainer filterContainer = (FilterContainer)this.getControl(KEY_FILTERCONTAINERAP);
        filterContainer.setContext(billList.getContext());
        filterContainer.setBillFormId("eci_company");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String keyword = (String)this.getView().getFormShowParameter().getCustomParam("keyword");
        if (!StringUtils.isEmpty((String)keyword)) {
            Search search = (Search)this.getControl(KEY_SEARCHAP);
            search.setSearchKey(keyword);
            this.getPageCache().putBigObject("eci_search_company", keyword);
        }
        this.getView().setVisible(Boolean.valueOf(!StringUtils.isEmpty((String)keyword)), new String[]{KEY_FLEXPANELAP});
        HashMap<String, Boolean> data = new HashMap<String, Boolean>(1);
        data.put("scrollload", Boolean.TRUE);
        this.getView().updateControlMetadata("cardview", data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientCallBack(ClientCallBackEvent e) {
        if ("update_keyword".equals(e.getName())) {
            this.getView().showLoading(null);
            try {
                String s = this.getPageCache().getBigObject("eci_search_company");
                Search search = (Search)this.getControl(KEY_SEARCHAP);
                search.setSearchKey(s);
                if (StringUtils.isNotEmpty((String)s)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FLEXPANELAP});
                }
                this.refresh();
            }
            finally {
                this.getView().hideLoading();
            }
        }
        if ("open_report_by_keyword".equals(e.getName())) {
            this.getView().showLoading(null);
            try {
                String json = this.getPageCache().get("eci_select_company");
                if (StringUtils.isNotEmpty((String)json)) {
                    CompanyInfo companyInfo = (CompanyInfo)JSON.parseObject((String)json, CompanyInfo.class);
                    GSSFReportApiResult result = this.eciService.findGSSFReportByKeyWord(companyInfo.getName());
                    this.openReport(companyInfo, result);
                }
            }
            catch (KDException ex) {
                this.eciService.handleException((Exception)((Object)ex));
            }
            finally {
                this.notifyStatusCardChange();
                this.getView().hideLoading();
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                ECISearchResultFormPlugin.this.openReportByRowIndex(evt.getRow());
            }
        });
        billList.addListRowDoubleClickListener(new ListRowClickListener(){

            public void listRowDoubleClick(ListRowClickEvent evt) {
                ECISearchResultFormPlugin.this.openReportByRowIndex(evt.getRow());
            }
        });
        FilterContainer filterContainer = (FilterContainer)this.getControl(KEY_FILTERCONTAINERAP);
        filterContainer.addSearchClickListener(searchClickEvent -> this.refresh());
        Search search = (Search)this.getControl(KEY_SEARCHAP);
        search.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent searchEnterEvent) {
                if (StringUtils.isEmpty((String)searchEnterEvent.getText())) {
                    ECISearchResultFormPlugin.this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u641c\u7d22\u7684\u4f01\u4e1a\u540d", (String)"ECISearchResultFormPlugin_1", (String)"data-eci-formplugin", (Object[])new Object[0]));
                    return;
                }
                ECISearchResultFormPlugin.this.getView().setVisible(Boolean.TRUE, new String[]{ECISearchResultFormPlugin.KEY_FLEXPANELAP});
                ECISearchResultFormPlugin.this.getPageCache().putBigObject("eci_search_company", searchEnterEvent.getText());
                ECISearchResultFormPlugin.this.refresh();
            }

            public List<String> getSearchList(SearchEnterEvent evt) {
                if (StringUtils.isEmpty((String)evt.getText())) {
                    return Collections.emptyList();
                }
                try {
                    return ECISearchResultFormPlugin.this.eciService.qyList(evt.getText());
                }
                catch (Exception ignore) {
                    return Collections.emptyList();
                }
            }
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openReportByRowIndex(int rowIndex) {
        if (rowIndex <= -1) {
            return;
        }
        CompanyInfo companyInfo = null;
        String searchResult = this.getPageCache().getBigObject("eci_search_result");
        if (StringUtils.isNotEmpty((String)searchResult)) {
            JSONObject jsonObject = JSON.parseObject((String)searchResult);
            companyInfo = (CompanyInfo)jsonObject.getObject(String.valueOf(rowIndex + 1), CompanyInfo.class);
        }
        if (companyInfo == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762\uff01", (String)"ECISearchResultFormPlugin_0", (String)"data-eci-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showLoading(null);
        try {
            this.getPageCache().put("eci_select_company", JSON.toJSONString((Object)companyInfo));
            this.openReport(companyInfo);
        }
        catch (KDException ex) {
            this.eciService.handleException((Exception)((Object)ex));
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void openReport(CompanyInfo companyInfo) {
        CheckReportApiResult checkOldReportResult = this.eciService.checkCustomerReport(companyInfo.getName());
        GSSFReportApiResult result = null;
        if (checkOldReportResult != null && checkOldReportResult.isCheckResult() && StringUtils.isNotEmpty((String)checkOldReportResult.getReportId())) {
            result = this.eciService.findGSSFReportByReportId(checkOldReportResult.getReportId());
        }
        if (result == null) {
            BalanceInfo balance = null;
            try {
                balance = this.eciService.getBalanceFromCache();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (balance != null && balance.getBalance() + balance.getTestBalance() <= 0) {
                this.eciService.showSubscriptionNotify(balance);
                this.notifyStatusCardChange();
            } else if ("true".equals(SessionManager.getCurrent().get("eci_open_confirm_no_show_next_time"))) {
                this.getView().addClientCallBack("open_report_by_keyword");
                log.debug("open report without confirm");
            } else {
                this.showConfirm(ResManager.loadKDString((String)"\u6253\u5f00\u62a5\u544a\u9700\u6263\u51cf1\u6b21\u67e5\u8be2\u989d\u5ea6\uff0c\u786e\u5b9a\u8981\u6253\u5f00\u5417\uff1f", (String)"ECISearchResultFormPlugin_2", (String)"data-eci-formplugin", (Object[])new Object[0]), new CloseCallBack((IFormPlugin)this, "open_report_by_keyword"));
                log.debug("open report with confirm");
            }
        } else {
            this.openReport(companyInfo, result);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject returnObj;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("open_report_by_keyword".equals(actionId) && StringUtils.isNotEmpty((String)returnData) && "ok".equals((returnObj = JSON.parseObject((String)returnData)).getString("result"))) {
            if (returnObj.getBooleanValue("no_show_next_time")) {
                SessionManager.getCurrent().put("eci_open_confirm_no_show_next_time", "true");
            }
            this.getView().addClientCallBack("open_report_by_keyword");
        }
    }

    private void openReport(CompanyInfo companyInfo, GSSFReportApiResult result) {
        if (result == null || StringUtils.isEmpty((String)result.getIframeUrl())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u627e\u5230\u62a5\u544a\uff0c\u8bf7\u7a0d\u540e\u518d\u5c1d\u8bd5", (String)"ECISearchResultFormPlugin_3", (String)"data-eci-formplugin", (Object[])new Object[0]));
            return;
        }
        this.eciService.showReport(companyInfo.getName(), companyInfo.getCreditCode(), result);
        ECIOpLog.add((String)"view_report", (String)companyInfo.getName(), (String)result.getReportId(), (String)companyInfo.getCreditCode(), (boolean)result.isDeduction());
        this.notifyHistoryCardChange();
    }

    private void refresh() {
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        FilterContainer filterContainer = (FilterContainer)this.getControl(KEY_FILTERCONTAINERAP);
        filterContainer.getContext().setClearSelection(true);
        billList.bindData(null);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("refresh".equals(evt.getOperationKey())) {
            this.refresh();
        }
    }
}

