/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.data.eci.core.ECIConfig;
import kd.data.eci.model.BalanceInfo;
import kd.data.eci.model.CheckReportApiResult;
import kd.data.eci.model.CompanySearchApiResult;
import kd.data.eci.model.ECIConfigInfo;
import kd.data.eci.model.GSSFDownloadUrlInfo;
import kd.data.eci.model.GSSFReportApiResult;
import kd.data.eci.model.RequestCustomer;
import kd.data.eci.util.Cipher3DES;
import kd.data.eci.util.CipherMd5;
import kd.data.eci.util.RsaSignCoder;

public class BigDataXYClient {
    public static final String APPLICATION_JSON_VALUE = "application/json";
    private static final Log log = LogFactory.getLog(BigDataXYClient.class);
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_LONG_TIMEOUT = 45000;
    private static final ThreadLocal<StringBuilder> logMsg = ThreadLocals.create();

    private static void clearLogMsg() {
        logMsg.remove();
    }

    private static StringBuilder getLogMsg() {
        StringBuilder builder = logMsg.get();
        if (builder == null) {
            builder = new StringBuilder();
            logMsg.set(builder);
        }
        return builder;
    }

    protected JSONObject getResult(String url, Map<String, Object> data, int timeout) {
        String ret;
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("Accept", APPLICATION_JSON_VALUE);
        String fixUrl = ECIConfig.getSystemUrl() + url;
        String logData = JSON.toJSONString(data);
        BigDataXYClient.getLogMsg().append("\nrequest:\n").append(logData).append("\nurl:").append(fixUrl);
        long begin = System.currentTimeMillis();
        try {
            ret = HttpClientUtils.postAppJson((String)fixUrl, header, data, (int)timeout, (int)timeout);
        }
        catch (Exception ex) {
            BigDataXYClient.getLogMsg().append("\ncost:").append(System.currentTimeMillis() - begin);
            log.error(BigDataXYClient.getLogMsg().toString(), (Throwable)ex);
            throw new KDException(new ErrorCode("eci_error", ResManager.loadKDString((String)"\u63a5\u53e3\u8bbf\u95ee\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"BigDataXYClient_2", (String)"data-eci-core", (Object[])new Object[0])), new Object[0]);
        }
        BigDataXYClient.getLogMsg().append("\ncost:").append(System.currentTimeMillis() - begin);
        BigDataXYClient.getLogMsg().append("\nresponse:").append(ret);
        log.debug(String.format("\nrequest:%s\njson:%s\nresponse:%s", fixUrl, logData, ret));
        if (StringUtils.isEmpty((String)ret)) {
            return null;
        }
        return JSON.parseObject((String)ret);
    }

    protected Map<String, Object> buildRequestData(ECIConfigInfo info, Map<String, Object> data) throws Exception {
        BigDataXYClient.clearLogMsg();
        JSONObject param = new JSONObject();
        param.putAll(data);
        param.put("client_id", (Object)info.getClientId());
        param.put("client_secret", (Object)info.getClientSecret());
        String paramClearText = param.toJSONString();
        log.info("request clear:\n" + paramClearText.replace(info.getClientSecret(), "xxx"));
        BigDataXYClient.getLogMsg().append("request clear:\n").append(paramClearText);
        String vector = StringUtils.randomWord((int)8);
        String encryptData = Cipher3DES.encrypt(paramClearText, info.getPublicKey(), vector);
        String signStr = CipherMd5.encrypt(encryptData).toUpperCase();
        String sign = RsaSignCoder.sign(signStr, info.getPrivateKey());
        LinkedHashMap<String, Object> reqData = new LinkedHashMap<String, Object>(4);
        reqData.put("appid", info.getClientId());
        reqData.put("data", encryptData);
        reqData.put("vector", vector);
        reqData.put("sign", sign);
        return reqData;
    }

    protected String buildResult(ECIConfigInfo info, JSONObject resultObj) throws Exception {
        Integer status;
        Integer n = status = resultObj != null ? resultObj.getInteger("status") : null;
        if (status == null || status != 200) {
            String msg;
            if (status != null && status == 206) {
                return null;
            }
            String string = msg = resultObj != null ? resultObj.getString("msg") : null;
            if (StringUtils.isEmpty((String)msg)) {
                msg = ResManager.loadKDString((String)"\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0c\u6570\u636e\u8fd4\u56de\u5f02\u5e38", (String)"BigDataXYClient_0", (String)"data-eci-core", (Object[])new Object[0]);
            }
            String errorCode = "eci_result";
            if (status != null) {
                errorCode = errorCode + "_" + status;
            }
            log.error(BigDataXYClient.getLogMsg().toString());
            BigDataXYClient.clearLogMsg();
            throw new KDException(new ErrorCode(errorCode, msg), new Object[0]);
        }
        BigDataXYClient.clearLogMsg();
        JSONObject data = resultObj.getJSONObject("data");
        String resultString = data.getString("result");
        String resultSign = data.getString("sign");
        String resultSignStr = CipherMd5.encrypt(resultString).toUpperCase();
        if (!RsaSignCoder.verify(resultSignStr, info.getJwyPublicKey(), resultSign)) {
            throw new KDException(new ErrorCode("eci_result", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25", (String)"BigDataXYClient_1", (String)"data-eci-core", (Object[])new Object[0])), new Object[0]);
        }
        if (data.get((Object)"vector") != null) {
            String vector = data.getString("vector");
            String resultDecrypted = Cipher3DES.decrypt(resultString, info.getJwyPublicKey(), vector);
            log.debug("response clear:\n" + resultDecrypted);
            return resultDecrypted;
        }
        return null;
    }

    private Map<String, Object> requestCustomerToMap(RequestCustomer company) {
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("cosmicCompanyId", company.getCosmicCompanyId());
        data.put("cosmicProduct", company.getCosmicProduct());
        data.put("cosmicProductNo", company.getCosmicProductNo());
        data.put("prodinstcode", company.getProdInstCode());
        data.put("companyName", company.getCompanyName());
        return data;
    }

    public ECIConfigInfo getCompanyConfigInfo(RequestCustomer customer) throws Exception {
        Map<String, Object> requestData;
        JSONObject resultObj;
        String url = "/api/v4/verify/cosmic/companyinfo";
        Map<String, Object> data = this.requestCustomerToMap(customer);
        ECIConfigInfo configInfo = ECIConfig.getSystemConfig();
        String result = this.buildResult(configInfo, resultObj = this.getResult(url, requestData = this.buildRequestData(configInfo, data), 5000));
        if (StringUtils.isEmpty((String)result)) {
            return null;
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        ECIConfigInfo rtn = new ECIConfigInfo();
        rtn.setClientId(resultJson.getString("clientId"));
        rtn.setClientSecret(resultJson.getString("clientSecret"));
        rtn.setPublicKey(resultJson.getString("thPublicKey"));
        rtn.setPrivateKey(resultJson.getString("thPrivateKey"));
        rtn.setJwyPublicKey(resultJson.getString("kdPublicKey"));
        rtn.setStatus(resultJson.getString("entStatus"));
        if (StringUtils.isEmpty((String)rtn.getClientId())) {
            return null;
        }
        return rtn;
    }

    public BalanceInfo getCustomerBalance(RequestCustomer customer) throws Exception {
        Map<String, Object> requestData;
        JSONObject resultObj;
        String url = "/api/v4/verify/cosmic/balance";
        Map<String, Object> data = this.requestCustomerToMap(customer);
        ECIConfigInfo configInfo = ECIConfig.getSystemConfig();
        String result = this.buildResult(configInfo, resultObj = this.getResult(url, requestData = this.buildRequestData(configInfo, data), 5000));
        if (StringUtils.isEmpty((String)result)) {
            return null;
        }
        return (BalanceInfo)JSON.parseObject((String)result, BalanceInfo.class);
    }

    public List<String> qyList(String keyword) throws Exception {
        String url = "/api/v4/verify/cosmic/qylist/single";
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("keyword", keyword);
        ECIConfigInfo configInfo = ECIConfig.getSystemConfig();
        Map<String, Object> requestData = this.buildRequestData(configInfo, data);
        JSONObject resultObj = this.getResult(url, requestData, 5000);
        String result = this.buildResult(configInfo, resultObj);
        if (StringUtils.isEmpty((String)result)) {
            return Collections.emptyList();
        }
        JSONArray jsonArray = JSON.parseArray((String)result);
        if (jsonArray == null || jsonArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> rtn = new ArrayList<String>(jsonArray.size());
        int len = jsonArray.size();
        for (int i = 0; i < len; ++i) {
            String entName = jsonArray.getJSONObject(i).getString("entname");
            rtn.add(entName);
        }
        return rtn;
    }

    public CompanySearchApiResult searchCompany(String keyword, Map<String, String> filter, int skip) throws Exception {
        Map<String, Object> requestData;
        JSONObject resultObj;
        ECIConfigInfo configInfo;
        String result;
        String url = "/api/v4/verify/cosmic/qylist/advance/search";
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("keyword", keyword);
        data.put("skip", skip);
        if (filter != null && !filter.isEmpty()) {
            data.putAll(filter);
        }
        if (StringUtils.isEmpty((String)(result = this.buildResult(configInfo = ECIConfig.getSystemConfig(), resultObj = this.getResult(url, requestData = this.buildRequestData(configInfo, data), 5000))))) {
            return null;
        }
        return (CompanySearchApiResult)JSON.parseObject((String)result, CompanySearchApiResult.class);
    }

    public CheckReportApiResult checkCustomerReport(RequestCustomer customer, String keyword) throws Exception {
        String url = "/api/v4/verify/cosmic/company/check";
        if (StringUtils.isEmpty((String)keyword)) {
            return null;
        }
        ECIConfigInfo configInfo = ECIConfig.getSystemConfig();
        Map<String, Object> data = this.requestCustomerToMap(customer);
        data.put("keyword", keyword);
        Map<String, Object> requestData = this.buildRequestData(configInfo, data);
        JSONObject resultObj = this.getResult(url, requestData, 5000);
        String result = this.buildResult(configInfo, resultObj);
        if (StringUtils.isEmpty((String)result)) {
            return null;
        }
        return (CheckReportApiResult)JSON.parseObject((String)result, CheckReportApiResult.class);
    }

    public GSSFReportApiResult findGSSFReportByKeyWord(ECIConfigInfo configInfo, RequestCustomer customer, String keyword) throws Exception {
        String url = "/api/v4/verify/cosmic/gssf/report";
        if (StringUtils.isEmpty((String)keyword)) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("keyword", keyword);
        data.put("cosmicCompanyId", customer.getCosmicCompanyId());
        data.put("accountId", RequestContext.get().getAccountId());
        data.put("userId", RequestContext.get().getUserId());
        Map<String, Object> requestData = this.buildRequestData(configInfo, data);
        JSONObject resultObj = this.getResult(url, requestData, 45000);
        String result = this.buildResult(configInfo, resultObj);
        if (StringUtils.isEmpty((String)result)) {
            return null;
        }
        return (GSSFReportApiResult)JSON.parseObject((String)result, GSSFReportApiResult.class);
    }

    public GSSFReportApiResult findGSSFReportByReportId(ECIConfigInfo configInfo, RequestCustomer customer, String reportId) throws Exception {
        String url = "/api/v4/verify/cosmic/gssf/report";
        if (StringUtils.isEmpty((String)reportId)) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("reportId", reportId);
        data.put("cosmicCompanyId", customer.getCosmicCompanyId());
        data.put("accountId", RequestContext.get().getAccountId());
        data.put("userId", RequestContext.get().getUserId());
        Map<String, Object> requestData = this.buildRequestData(configInfo, data);
        JSONObject resultObj = this.getResult(url, requestData, 5000);
        String result = this.buildResult(configInfo, resultObj);
        if (StringUtils.isEmpty((String)result)) {
            return null;
        }
        return (GSSFReportApiResult)JSON.parseObject((String)result, GSSFReportApiResult.class);
    }

    public GSSFDownloadUrlInfo findGSSFDownloadUrl(String reportId) throws Exception {
        Integer status;
        String url = "/api/v4/verify/cosmic/gssf/report/pdf";
        if (StringUtils.isEmpty((String)reportId)) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("reportId", reportId);
        ECIConfigInfo configInfo = ECIConfig.getSystemConfig();
        Map<String, Object> requestData = this.buildRequestData(configInfo, data);
        JSONObject resultObj = this.getResult(url, requestData, 45000);
        GSSFDownloadUrlInfo rtn = new GSSFDownloadUrlInfo();
        rtn.setStatus(500);
        Integer n = status = resultObj != null ? resultObj.getInteger("status") : null;
        if (status != null && status == 445) {
            rtn.setStatus(445);
        } else {
            String result = this.buildResult(configInfo, resultObj);
            if (StringUtils.isNotEmpty((String)result)) {
                rtn.setPdfUrl(JSON.parseObject((String)result).getString("pdfUrl"));
                if (StringUtils.isNotEmpty((String)rtn.getPdfUrl())) {
                    rtn.setStatus(200);
                }
            }
        }
        return rtn;
    }

    public boolean sendGSSFToEmail(String reportId, String email) throws Exception {
        String url = "/api/v4/verify/cosmic/gssf/report/email";
        if (StringUtils.isEmpty((String)reportId) || StringUtils.isEmpty((String)email)) {
            return false;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("reportId", reportId);
        data.put("email", email);
        ECIConfigInfo configInfo = ECIConfig.getSystemConfig();
        Map<String, Object> requestData = this.buildRequestData(configInfo, data);
        JSONObject resultObj = this.getResult(url, requestData, 45000);
        BigDataXYClient.clearLogMsg();
        return resultObj != null && resultObj.getInteger("status") == 200;
    }
}

