/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.data.eci.model.ECIConfigInfo;

public class ECIConfig {
    private static final Log log = LogFactory.getLog(ECIConfig.class);
    private static final ECIConfig config = new ECIConfig();
    private final Map<String, String> urls = new LinkedHashMap<String, String>(2);
    private final Map<String, ECIConfigInfo> clients = new LinkedHashMap<String, ECIConfigInfo>(2);

    private ECIConfig() {
        this.initFromFile("META-INF/kd/data/eci/config/kd.data.eci.config.Client");
    }

    private static String getType() {
        String type = System.getProperty("data.eci.client.type");
        if (StringUtils.isEmpty((String)type)) {
            type = "pro";
        }
        return type;
    }

    public static String getSystemUrl() {
        return ECIConfig.config.urls.get(ECIConfig.getType());
    }

    public static ECIConfigInfo getSystemConfig() {
        return ECIConfig.config.clients.get(ECIConfig.getType());
    }

    private void initFromFile(String fileName) {
        block17: {
            try {
                ClassLoader classLoader = ECIConfig.class.getClassLoader();
                Enumeration<URL> fileUrls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
                if (fileUrls == null) break block17;
                while (fileUrls.hasMoreElements()) {
                    URL url = fileUrls.nextElement();
                    log.info("load config from " + url);
                    try {
                        InputStream is = url.openStream();
                        Throwable throwable = null;
                        try {
                            JSONObject json = (JSONObject)JSON.parseObject((InputStream)is, (Charset)StandardCharsets.UTF_8, JSONObject.class, (Feature[])new Feature[0]);
                            if (json == null) continue;
                            Set keySet = json.keySet();
                            for (String key : keySet) {
                                ECIConfigInfo config;
                                JSONObject jsonObject = json.getJSONObject(key);
                                if (jsonObject == null) continue;
                                String u = jsonObject.getString("url");
                                if (StringUtils.isNotEmpty((String)u)) {
                                    this.urls.put(key, u);
                                }
                                if ((config = (ECIConfigInfo)jsonObject.toJavaObject(ECIConfigInfo.class)) == null || !StringUtils.isNotEmpty((String)config.getClientId())) continue;
                                this.clients.put(key, config);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                    catch (Exception e) {
                        log.error("Exception when load file: " + url + ") in " + url, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.error("Exception when load  file: " + fileName + ").", (Throwable)e);
            }
        }
    }
}

