/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.util;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class KeyUtil {
    public static final String KEY_ALGORITHM = "RSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";

    public static Map<String, String> getSecretKey() {
        return KeyUtil.getKey();
    }

    private static Map<String, String> getKey() {
        try {
            Map<String, Object> keyMap = KeyUtil.initKey();
            String publicKey = KeyUtil.getPublicKey(keyMap);
            String privateKey = KeyUtil.getPrivateKey(keyMap);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("privateKey", privateKey);
            map.put("publicKey", publicKey);
            return map;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static String getPublicKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return KeyUtil.encryptBASE64(key.getEncoded());
    }

    protected static String getPrivateKey(Map<String, Object> keyMap) throws Exception {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return KeyUtil.encryptBASE64(key.getEncoded());
    }

    protected static String encryptBASE64(byte[] key) throws Exception {
        return Base64.getEncoder().encodeToString(key);
    }

    protected static Map<String, Object> initKey() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }
}

