/*
 * Decompiled with CFR 0.152.
 */
package kd.data.eci.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.eci.util.Cipher3DES;
import kd.data.eci.util.CipherBase64;

public class RsaSignCoder {
    private static final Log log = LogFactory.getLog(Cipher3DES.class);

    public static String sign(String datas, String privates) throws UnsupportedEncodingException {
        byte[] data = datas.getBytes("utf-8");
        byte[] privateKey = CipherBase64.decryptBASE64(privates);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign(priKey);
            signature.update(data);
            return CipherBase64.encryptBASE64(signature.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static boolean verify(String datas, String publicKeys, String signs) throws UnsupportedEncodingException {
        byte[] data = datas.getBytes("utf-8");
        byte[] publicKey = CipherBase64.decryptBASE64(publicKeys);
        byte[] sign = CipherBase64.decryptBASE64(signs);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(pubKey);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            log.error(e.getMessage());
            return false;
        }
    }
}

