/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.disf.algo.AlgoDataSetDataPageColToRowReader;
import kd.data.disf.algo.IColumnValueConverter;

public class AlgoDataPageHierarchyColToRowReader
extends AlgoDataSetDataPageColToRowReader {
    private static final long serialVersionUID = 9223178689740195501L;
    private static final Log logger = LogFactory.getLog(AlgoDataPageHierarchyColToRowReader.class);
    protected Integer[] hierarchyDimColIndexs;
    private Map<String, String> originalDimNumberMap;
    private Map<String, String> rigidConditionDimMemMap;

    public AlgoDataPageHierarchyColToRowReader(int pageSize, int outputColumnCnt, Map<String, Integer[]> baseFieldReadWriteIndexs, Map<String, Integer[]> rowKeyDimReadWriteIndexs, Map<Object, Integer> transKeyMap, IColumnValueConverter<Object, Object[][]> dimGroupConverter, Integer[] hierarchyDimColIndexs, boolean superLongData, Map<String, String> originalDimNumberMap, Map<String, String> rigidConditionDimMemMap) {
        this(pageSize, outputColumnCnt, baseFieldReadWriteIndexs, rowKeyDimReadWriteIndexs, dimGroupConverter, hierarchyDimColIndexs, superLongData, originalDimNumberMap, rigidConditionDimMemMap);
        this.transKeyMap = transKeyMap;
    }

    protected AlgoDataPageHierarchyColToRowReader(int pageSize, int outputColumnCnt, Map<String, Integer[]> baseFieldReadWriteIndexs, Map<String, Integer[]> rowKeyDimReadWriteIndexs, IColumnValueConverter<Object, Object[][]> dimGroupConverter, Integer[] hierarchyDimColIndexs, boolean superLongData, Map<String, String> originalDimNumberMap, Map<String, String> rigidConditionDimMemMap) {
        super(pageSize, outputColumnCnt, baseFieldReadWriteIndexs, rowKeyDimReadWriteIndexs, dimGroupConverter, superLongData);
        this.dimGroupConverter = dimGroupConverter;
        this.hierarchyDimColIndexs = hierarchyDimColIndexs;
        this.originalDimNumberMap = originalDimNumberMap;
        this.rigidConditionDimMemMap = rigidConditionDimMemMap;
    }

    @Override
    public int fetchFromDataRow(Row dataRow) {
        int result = super.fetchFromDataRow(dataRow);
        if (result > this.pageValues.length - 1) {
            return result;
        }
        this.fetchDimensionRowKey(this.pageValues[this.currentWriteRowIndex]);
        return result;
    }

    @Override
    public String toString() {
        return "AlgoDataPageHierarchyColToRowReader [hierarchyDimColIndexs=" + Arrays.toString((Object[])this.hierarchyDimColIndexs) + ", dimGroupConverter=" + this.dimGroupConverter + "]";
    }

    @Override
    protected void fetchDimensionRowKey(Object[] outputTarget) {
        List<Integer> hierarchyDimIndex = Arrays.asList(this.hierarchyDimColIndexs);
        this.rowKeyDimReadWriteIndexs.forEach((number, index) -> {
            if (!hierarchyDimIndex.contains(index[1])) {
                Object[][] dimGroupInfoBufs;
                int dimGroupConverIdx = index[0] - 1;
                if (this.transKeyMap == null || this.transKeyMap.size() == 0) {
                    dimGroupConverIdx = index[0];
                }
                if ((dimGroupInfoBufs = (Object[][])this.dimGroupConverter.convert(dimGroupConverIdx, outputTarget[index[1]], new Object[0])) != null) {
                    if (this.displayNumberDimSet.contains(number)) {
                        Object[] dimGroupInfoBuf = dimGroupInfoBufs[0];
                        outputTarget[index[1].intValue()] = outputTarget[index[1]] + " " + dimGroupInfoBuf[0];
                    } else {
                        Object[] dimGroupInfoBuf = dimGroupInfoBufs[0];
                        System.arraycopy(dimGroupInfoBuf, 0, outputTarget, index[1], 1);
                    }
                }
            }
        });
    }

    protected boolean fetchDimensionHierarchy(Object[] outputTarget, Row dataRow) {
        int dimGroupIndex = 0;
        ArrayList<Object[]> copyRowBufList = new ArrayList<Object[]>(10);
        Integer[] entitiIndex = (Integer[])this.rowKeyDimReadWriteIndexs.get(this.originalDimNumberMap.get("entity"));
        Integer[] integerArray = this.hierarchyDimColIndexs;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            Object[][] dimGroupInfoBuf;
            int dimIndex = integerArray[i];
            if (outputTarget[dimIndex + 1] != null) continue;
            Object memberNumber = outputTarget[dimIndex];
            ArrayList<Object[]> dimCopyRowBufList = null;
            if (entitiIndex != null && entitiIndex[1] == dimIndex) {
                String period;
                StringBuilder dateStringBuilder = new StringBuilder();
                Integer[] yearIndex = (Integer[])this.rowKeyDimReadWriteIndexs.get(this.originalDimNumberMap.get("year"));
                Integer[] periodIndex = (Integer[])this.rowKeyDimReadWriteIndexs.get(this.originalDimNumberMap.get("period"));
                String year = yearIndex == null ? this.rigidConditionDimMemMap.get("year") : dataRow.get(yearIndex[0].intValue()).toString();
                Integer periodCoverIndex = null;
                if (periodIndex == null) {
                    period = this.rigidConditionDimMemMap.get("period");
                    periodCoverIndex = this.rowKeyDimReadWriteIndexs.size();
                    Iterator<String> iterator = this.rigidConditionDimMemMap.keySet().iterator();
                    while (iterator.hasNext() && !"period".equals(iterator.next())) {
                        Integer n2 = periodCoverIndex;
                        Integer n3 = periodCoverIndex = Integer.valueOf(periodCoverIndex + 1);
                    }
                } else {
                    periodCoverIndex = periodIndex[0];
                    period = dataRow.get(periodIndex[0].intValue()).toString();
                }
                Object[][] perioddimGroupInfo = (Object[][])this.dimGroupConverter.convert(periodCoverIndex, period, new Object[0]);
                dateStringBuilder.append(year.substring(2));
                dateStringBuilder.append(perioddimGroupInfo[0].length == 4 ? perioddimGroupInfo[0][3] : perioddimGroupInfo[0][1]);
                dimGroupInfoBuf = (Object[][])this.dimGroupConverter.convert(dimGroupIndex++, outputTarget[dimIndex], Integer.parseInt(dateStringBuilder.toString()));
            } else {
                dimGroupInfoBuf = (Object[][])this.dimGroupConverter.convert(dimGroupIndex++, outputTarget[dimIndex], new Object[0]);
            }
            if (dimGroupInfoBuf == null) {
                this.pageValues[this.currentWriteRowIndex] = new Object[this.outputColumnCnt];
                --this.currentWriteRowIndex;
                return false;
            }
            for (int i2 = 0; i2 < dimGroupInfoBuf.length; ++i2) {
                if (dimCopyRowBufList == null) {
                    dimCopyRowBufList = new ArrayList<Object[]>(10);
                }
                if (copyRowBufList.isEmpty()) {
                    if (i2 == 0) {
                        Object[] objects = dimGroupInfoBuf[i2];
                        System.arraycopy(objects, 0, outputTarget, dimIndex, 3);
                        if (!this.displayNumberIndexSet.contains(dimIndex)) continue;
                        outputTarget[dimIndex + 2] = memberNumber + " " + outputTarget[dimIndex + 2];
                        continue;
                    }
                    dimCopyRowBufList.add(outputTarget);
                    if (this.checkAndDeleteUnnecessaryData(dimCopyRowBufList, copyRowBufList)) {
                        return true;
                    }
                    Object[] rowBuf = this.pageValues[++this.currentWriteRowIndex];
                    System.arraycopy(outputTarget, 0, rowBuf, 0, outputTarget.length);
                    Object[] objects = dimGroupInfoBuf[i2];
                    System.arraycopy(objects, 0, rowBuf, dimIndex, 3);
                    if (this.displayNumberIndexSet.contains(dimIndex)) {
                        rowBuf[dimIndex + 2] = memberNumber + " " + rowBuf[dimIndex + 2];
                    }
                    dimCopyRowBufList.add(rowBuf);
                    continue;
                }
                if (i2 == 0) {
                    for (Object[] rowBuf : copyRowBufList) {
                        Object[] objects = dimGroupInfoBuf[i2];
                        System.arraycopy(objects, 0, rowBuf, dimIndex, 3);
                        if (!this.displayNumberIndexSet.contains(dimIndex)) continue;
                        rowBuf[dimIndex + 2] = memberNumber + " " + rowBuf[dimIndex + 2];
                    }
                    continue;
                }
                for (Object[] copyBuf : copyRowBufList) {
                    if (this.checkAndDeleteUnnecessaryData(dimCopyRowBufList, copyRowBufList)) {
                        return true;
                    }
                    Object[] rowBuf = this.pageValues[++this.currentWriteRowIndex];
                    System.arraycopy(copyBuf, 0, rowBuf, 0, copyBuf.length);
                    Object[] objects = dimGroupInfoBuf[i2];
                    System.arraycopy(objects, 0, rowBuf, dimIndex, 3);
                    if (this.displayNumberIndexSet.contains(dimIndex)) {
                        rowBuf[dimIndex + 2] = memberNumber + " " + rowBuf[dimIndex + 2];
                    }
                    dimCopyRowBufList.add(rowBuf);
                }
            }
            if (dimCopyRowBufList == null) continue;
            copyRowBufList.addAll(dimCopyRowBufList);
        }
        copyRowBufList.remove(outputTarget);
        for (Object[] copyRowBuf : copyRowBufList) {
            this.fetchDimensionRowKey(copyRowBuf);
        }
        return false;
    }

    public boolean checkAndDeleteUnnecessaryData(List<Object[]> dimCopyRowBufList, List<Object[]> copyRowBufList) {
        if (this.currentWriteRowIndex == this.pageValues.length - 1) {
            for (int i = this.pageValues.length - 1; i > this.currentWriteRowIndex - (dimCopyRowBufList.size() + copyRowBufList.size()); --i) {
                this.pageValues[i] = null;
            }
            return true;
        }
        return false;
    }
}

