/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.algo;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.util.StringUtils;
import kd.data.disf.algo.AlgoDataPageHierarchyColToRowReader;
import kd.data.disf.algo.IColumnValueConverter;

public class AlgoDataPageHierarchyReader
extends AlgoDataPageHierarchyColToRowReader {
    private static final long serialVersionUID = 9223178689740195501L;

    public AlgoDataPageHierarchyReader(int pageSize, int outputColumnCnt, Map<String, Integer[]> baseFieldReadWriteIndexs, Map<String, Integer[]> rowKeyDimReadWriteIndexs, IColumnValueConverter<Object, Object[][]> dimGroupConverter, Integer[] hierarchyDimColIndexs, boolean superLongData, Map<String, String> originalDimNumberMap, Map<String, String> rigidConditionDimMemMap) {
        super(pageSize, outputColumnCnt, baseFieldReadWriteIndexs, rowKeyDimReadWriteIndexs, dimGroupConverter, hierarchyDimColIndexs, superLongData, originalDimNumberMap, rigidConditionDimMemMap);
        if (rowKeyDimReadWriteIndexs != null) {
            Iterator<Integer[]> iterator = rowKeyDimReadWriteIndexs.values().iterator();
            int maxWriteIndex = 0;
            while (iterator.hasNext()) {
                Integer[] next = iterator.next();
                maxWriteIndex = Math.max(next[1], maxWriteIndex);
            }
            if (rowKeyDimReadWriteIndexs != null) {
                this.rowKeyBuffer = new Object[maxWriteIndex + 1];
            }
        }
    }

    @Override
    public int fetchFromDataRow(Row dataRow) {
        if (dataRow != null) {
            Object[] rowBuf = this.fetchRowKeyDimensions(dataRow);
            if (rowBuf != null && rowBuf.length == 0) {
                return this.currentWriteRowIndex + 1;
            }
            if (rowBuf == null) {
                return this.currentWriteRowIndex;
            }
            for (Integer[] readWriteIndex : this.baseFieldReadWriteIndexs.values()) {
                Object data = dataRow.get(readWriteIndex[0].intValue());
                if (readWriteIndex.length == 3) {
                    int year = Integer.parseInt(data.toString().substring(2));
                    int mouth = Integer.parseInt(dataRow.get(readWriteIndex[1].intValue()).toString().substring(3)) - 1;
                    Calendar cal = Calendar.getInstance();
                    cal.set(year, mouth, 1, 0, 0, 0);
                    rowBuf[readWriteIndex[2].intValue()] = cal.getTimeInMillis();
                    continue;
                }
                if (data == null || StringUtils.isEmpty((String)data.toString())) {
                    data = null;
                }
                rowBuf[readWriteIndex[1].intValue()] = this.superLongData && data != null ? new BigDecimal(String.valueOf(data)) : data;
            }
            if (this.fetchDimensionHierarchy(rowBuf, dataRow)) {
                return this.currentWriteRowIndex + 1;
            }
            this.fetchDimensionRowKey(rowBuf);
        }
        return this.currentWriteRowIndex;
    }
}

