/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.algo;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.data.disf.algo.AlgoDataSetDataPageReader;
import kd.data.disf.algo.IColumnValueConverter;

public class AlgoDataSetDataPageColToRowReader
extends AlgoDataSetDataPageReader {
    private static final long serialVersionUID = 9223178689740195501L;
    private static final Log logger = LogFactory.getLog(AlgoDataSetDataPageColToRowReader.class);
    protected int measureTypeReadIndex = 0;
    protected int dimHeirarchyTransTypeReadIndex = 0;
    protected int colToRowSize;
    protected boolean suppressMeasureTransformError;
    protected transient Map<Object, Integer> transKeyMap;

    protected AlgoDataSetDataPageColToRowReader(int pageSize, int outputColumnCnt, Map<String, Integer[]> baseFieldReadWriteIndexs, Map<String, Integer[]> rowKeyDimReadWriteIndexs, IColumnValueConverter<Object, Object[][]> dimGroupConverter, boolean superLongData) {
        super(pageSize, outputColumnCnt, baseFieldReadWriteIndexs, dimGroupConverter, rowKeyDimReadWriteIndexs, superLongData);
        this.queryMeasureCnt = baseFieldReadWriteIndexs.size();
    }

    public AlgoDataSetDataPageColToRowReader(int pageSize, int outputColumnCnt, Map<String, Integer[]> baseFieldReadWriteIndexs, Map<String, Integer[]> rowKeyDimReadWriteIndexs, Map<Object, Integer> transKeyMap, IColumnValueConverter<Object, Object[][]> dimGroupConverter, boolean superLongData) {
        this(pageSize, outputColumnCnt, baseFieldReadWriteIndexs, rowKeyDimReadWriteIndexs, dimGroupConverter, superLongData);
        this.transKeyMap = transKeyMap;
        if (this.transKeyMap == null || transKeyMap.isEmpty()) {
            throw new KDBizException("\u65e0\u6548\u7684\u5ea6\u91cf\u7c7b\u578b\u8f6c\u6362\u67e5\u8be2Map");
        }
    }

    @Override
    public String toString() {
        return "AlgoDataSetDataPageColToRowReader [suppressMeasureTransformError=" + this.suppressMeasureTransformError + ", rowKeyDimReadWriteIndexs=" + this.rowKeyDimReadWriteIndexs + ", currentRowKey=" + this.currentRowKey + ", rowKeyBuffer=" + Arrays.toString(this.rowKeyBuffer) + ", transKeyMap=" + this.transKeyMap + "]";
    }

    @Override
    public void clear() {
        super.clear();
        this.currentWriteRowIndex = -1;
        this.currentRowKey = null;
        if (this.rowKeyDimReadWriteIndexs != null) {
            this.rowKeyBuffer = new Object[this.rowKeyDimReadWriteIndexs.size()];
        }
    }

    @Override
    protected void customizedRowKeyDimensionData(boolean asNewRow, Object[] outputTarget) {
    }

    @Override
    public int fetchFromDataRow(Row dataRow) {
        if (dataRow != null) {
            Object[] writeCacheRow = this.fetchRowKeyDimensions(dataRow);
            if (writeCacheRow == null) {
                return this.currentWriteRowIndex + 1;
            }
            int transStartPos = this.transKeyMap.getOrDefault(dataRow.get(this.measureTypeReadIndex), -1) * this.queryMeasureCnt;
            if (transStartPos < 0) {
                logger.error(String.format("\u65e0\u6548\u7684\u5ea6\u91cf\u503c\u7c7b\u578b\u503c\uff1a%s; \u7c7b\u578bKeyMap=%s", dataRow.get(this.measureTypeReadIndex), this.transKeyMap));
                if (this.suppressMeasureTransformError) {
                    return this.currentWriteRowIndex;
                }
                throw new KDBizException(String.format("\u65e0\u6548\u7684\u5ea6\u91cf\u503c\u7c7b\u578b\u503c\uff1a%s; \u7c7b\u578bKeyMap=%s", dataRow.get(this.measureTypeReadIndex), this.transKeyMap));
            }
            for (Integer[] readWriteIdx : this.baseFieldReadWriteIndexs.values()) {
                Object data = dataRow.get(readWriteIdx[0].intValue());
                if (data == null || StringUtils.isEmpty((String)data.toString())) {
                    data = null;
                }
                writeCacheRow[transStartPos + readWriteIdx[1].intValue()] = this.superLongData && data != null ? new BigDecimal(String.valueOf(data)) : data;
            }
            this.fetchDimensionRowKey(writeCacheRow);
        }
        return this.currentWriteRowIndex;
    }

    @Override
    protected void fetchDimensionRowKey(Object[] outputTarget) {
        this.rowKeyDimReadWriteIndexs.forEach((number, index) -> {
            Object[][] dimGroupInfoBufs = (Object[][])this.dimGroupConverter.convert(index[0] - 1, outputTarget[index[1]], new Object[0]);
            if (dimGroupInfoBufs != null) {
                if (this.displayNumberDimSet.contains(number)) {
                    Object[] dimGroupInfoBuf = dimGroupInfoBufs[0];
                    outputTarget[index[1].intValue()] = outputTarget[index[1]] + " " + dimGroupInfoBuf[0];
                } else {
                    Object[] dimGroupInfoBuf = dimGroupInfoBufs[0];
                    System.arraycopy(dimGroupInfoBuf, 0, outputTarget, index[1], 1);
                }
            }
        });
    }
}

