/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.algo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.data.disf.algo.IColumnValueConverter;
import kd.data.disf.algo.IDataSetRowDataPageReader;

public class AlgoDataSetDataPageReader
implements IDataSetRowDataPageReader {
    private static final long serialVersionUID = 9223178689740195501L;
    protected boolean supressFetchExcceedPageSizeException;
    protected int pageSize;
    protected int outputColumnCnt;
    protected int currentWriteRowIndex;
    protected transient Object[][] pageValues;
    protected Map<String, Integer[]> baseFieldReadWriteIndexs;
    protected int queryMeasureCnt;
    protected Map<String, Integer[]> rowKeyDimReadWriteIndexs;
    protected transient Object[] rowKeyBuffer;
    protected String currentRowKey;
    protected boolean superLongData;
    protected IColumnValueConverter<Object, Object[][]> dimGroupConverter;
    protected Set<String> displayNumberDimSet;
    protected Set<Integer> displayNumberIndexSet;
    protected transient Calendar calendar = Calendar.getInstance();

    public AlgoDataSetDataPageReader(int pageSize, int outputColumnCnt, Map<String, Integer[]> baseFieldReadWriteIndexs, IColumnValueConverter<Object, Object[][]> dimGroupConverter, Map<String, Integer[]> rowKeyDimReadWriteIndexs, boolean superLongData) {
        this.reset(pageSize, outputColumnCnt, baseFieldReadWriteIndexs, dimGroupConverter, rowKeyDimReadWriteIndexs, superLongData);
    }

    public String toString() {
        return "AlgoDataSetDataPageReader{supressFetchExcceedPageSizeException=" + this.supressFetchExcceedPageSizeException + ", pageSize=" + this.pageSize + ", outputColumnCnt=" + this.outputColumnCnt + ", currentWriteRowIndex=" + this.currentWriteRowIndex + ", pageValues=" + Arrays.toString((Object[])this.pageValues) + ", baseFieldReadWriteIndexs=" + this.baseFieldReadWriteIndexs + ", queryMeasureCnt=" + this.queryMeasureCnt + ", dimGroupConverter=" + this.dimGroupConverter + '}';
    }

    public final void reset(int pageSize, int outputColumnCnt, Map<String, Integer[]> baseFieldReadWriteIndexs, IColumnValueConverter<Object, Object[][]> dimGroupConverter, Map<String, Integer[]> rowKeyDimReadWriteIndexs, boolean superLongData) {
        this.supressFetchExcceedPageSizeException = true;
        this.pageSize = pageSize;
        this.outputColumnCnt = outputColumnCnt;
        this.baseFieldReadWriteIndexs = baseFieldReadWriteIndexs;
        this.queryMeasureCnt = baseFieldReadWriteIndexs.size();
        this.dimGroupConverter = dimGroupConverter;
        this.superLongData = superLongData;
        this.rowKeyDimReadWriteIndexs = rowKeyDimReadWriteIndexs;
        if (rowKeyDimReadWriteIndexs != null) {
            Iterator<Integer[]> iterator = rowKeyDimReadWriteIndexs.values().iterator();
            int maxWriteIndex = 0;
            while (iterator.hasNext()) {
                Integer[] next = iterator.next();
                maxWriteIndex = Math.max(next[1], maxWriteIndex);
            }
            if (rowKeyDimReadWriteIndexs != null) {
                this.rowKeyBuffer = new Object[maxWriteIndex + 1];
            }
        }
        this.clear();
    }

    public void setDisplayNumberDimSet(Set<String> displayNumberDimSet) {
        this.displayNumberDimSet = displayNumberDimSet;
    }

    public void setDisplayNumberIndexSet(Set<Integer> displayNumberIndexSet) {
        this.displayNumberIndexSet = displayNumberIndexSet;
    }

    public void clear() {
        this.currentWriteRowIndex = -1;
        this.pageValues = new Object[this.pageSize][this.outputColumnCnt];
    }

    @Override
    public List<Object[]> resetToNew() {
        List<Object[]> oldValues = this.getPageValues();
        this.clear();
        return oldValues;
    }

    @Override
    public int getColumnCnt() {
        return this.outputColumnCnt;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean isEmpty() {
        return this.currentWriteRowIndex < 0;
    }

    protected boolean checkWriteBound() {
        if (this.currentWriteRowIndex >= this.pageSize - 1) {
            if (this.supressFetchExcceedPageSizeException) {
                return true;
            }
            throw new KDBizException(String.format("\u7f13\u5b58\u7684\u8bb0\u5f55\u6570\u91cf\uff0c\u5df2\u7ecf\u8fbe\u5230\u5e76\u8d85\u8fc7\u6570\u636e\u9875\u7684\u5bb9\u91cf! [%s:%s]", this.currentWriteRowIndex, this.pageSize));
        }
        return false;
    }

    protected Object fetchDataToRowBuf(Row dataRow, Object[] outputBuf, Integer[] readWriteIndex) {
        Object data = dataRow.get(readWriteIndex[0].intValue());
        if (readWriteIndex.length == 3) {
            int year = Integer.parseInt(data.toString().substring(2));
            int mouth = Integer.parseInt(dataRow.get(readWriteIndex[1].intValue()).toString().substring(3)) - 1;
            this.calendar.set(year, mouth, 1, 0, 0, 0);
            Long l = this.calendar.getTimeInMillis();
            outputBuf[readWriteIndex[2].intValue()] = l;
            return l;
        }
        if (data == null || StringUtils.isEmpty((String)data.toString())) {
            data = null;
        }
        return readWriteIndex[1] == null ? data : (outputBuf[readWriteIndex[1].intValue()] = this.superLongData && data != null ? new BigDecimal(String.valueOf(data)) : data);
    }

    @Override
    public int fetchFromDataRow(Row dataRow) {
        if (dataRow != null) {
            Object[] rowBuf = this.fetchRowKeyDimensions(dataRow);
            if (rowBuf != null && rowBuf.length == 0) {
                return this.currentWriteRowIndex + 1;
            }
            if (rowBuf == null) {
                return this.currentWriteRowIndex;
            }
            for (Integer[] outIndex : this.baseFieldReadWriteIndexs.values()) {
                this.fetchDataToRowBuf(dataRow, rowBuf, outIndex);
            }
            this.fetchDimensionRowKey(rowBuf);
        }
        return this.currentWriteRowIndex;
    }

    protected void fetchDimensionRowKey(Object[] outputTarget) {
        for (Map.Entry<String, Integer[]> entry : this.rowKeyDimReadWriteIndexs.entrySet()) {
            Integer[] index = entry.getValue();
            String dimNumber = entry.getKey();
            if (!(outputTarget[index[1]] instanceof String)) continue;
            Object[][] dimGroupInfoBufs = this.dimGroupConverter.convert(index[0], outputTarget[index[1]], new Object[0]);
            if (dimGroupInfoBufs != null) {
                Object[] dimGroupInfoBuf;
                if (this.displayNumberDimSet.contains(dimNumber)) {
                    dimGroupInfoBuf = dimGroupInfoBufs[0];
                    outputTarget[index[1].intValue()] = outputTarget[index[1]] + " " + dimGroupInfoBuf[0];
                    continue;
                }
                dimGroupInfoBuf = dimGroupInfoBufs[0];
                System.arraycopy(dimGroupInfoBuf, 0, outputTarget, index[1], 1);
                continue;
            }
            this.pageValues[this.currentWriteRowIndex] = new Object[this.outputColumnCnt];
            --this.currentWriteRowIndex;
            break;
        }
    }

    protected Object[] fetchRowKeyDimensions(Row dataRow) {
        Object[] writeCacheRow;
        StringBuilder rowKeyBufferStr = new StringBuilder();
        for (Integer[] readWriteIndex : this.rowKeyDimReadWriteIndexs.values()) {
            if (readWriteIndex.length == 3) {
                int year = Integer.parseInt(dataRow.get(readWriteIndex[0].intValue()).toString().substring(2));
                int mouth = Integer.parseInt(dataRow.get(readWriteIndex[1].intValue()).toString().substring(3)) - 1;
                Calendar cal = Calendar.getInstance();
                cal.set(year, mouth, 1, 0, 0, 0);
                this.rowKeyBuffer[readWriteIndex[2].intValue()] = cal.getTimeInMillis();
                continue;
            }
            rowKeyBufferStr.append(readWriteIndex[1] == null ? dataRow.get(readWriteIndex[0].intValue()) : (this.rowKeyBuffer[readWriteIndex[1].intValue()] = dataRow.get(readWriteIndex[0].intValue())));
        }
        String newRowKey = rowKeyBufferStr.toString();
        if (this.currentRowKey == null || !newRowKey.equals(this.currentRowKey)) {
            this.currentRowKey = newRowKey;
            if (this.checkWriteBound()) {
                return new Object[0];
            }
            writeCacheRow = this.pageValues[++this.currentWriteRowIndex];
            System.arraycopy(this.rowKeyBuffer, 0, writeCacheRow, 0, this.rowKeyBuffer.length);
            this.customizedRowKeyDimensionData(true, writeCacheRow);
        } else {
            writeCacheRow = null;
        }
        return writeCacheRow;
    }

    protected void customizedRowKeyDimensionData(boolean asNewRow, Object[] outputTarget) {
    }

    @Override
    public List<Object[]> getPageValues() {
        if (this.currentWriteRowIndex < 0) {
            return new ArrayList<Object[]>(0);
        }
        for (int i = 0; i < this.pageValues.length; ++i) {
            if (this.pageValues[i] != null) continue;
            return Arrays.asList(Arrays.copyOfRange(this.pageValues, 0, i));
        }
        return Arrays.asList(Arrays.copyOfRange(this.pageValues, 0, Math.min(this.pageSize, this.currentWriteRowIndex + 1)));
    }

    @Override
    public List<Object[]> flush() {
        return this.getPageValues();
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSupressFetchExcceedPageSizeException(boolean supressFetchExcceedPageSizeException) {
        this.supressFetchExcceedPageSizeException = supressFetchExcceedPageSizeException;
    }

    public boolean isSuperLongData() {
        return this.superLongData;
    }

    public void setSuperLongData(boolean superLongData) {
        this.superLongData = superLongData;
    }
}

