/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.algo;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.disf.algo.AlgoDataPageHierarchyColToRowReader;
import kd.data.disf.algo.AlgoDataPageHierarchyReader;
import kd.data.disf.algo.AlgoDataSetDataPageColToRowReader;
import kd.data.disf.algo.AlgoDataSetDataPageReader;
import kd.data.disf.algo.IColumnValueConverter;
import kd.data.disf.algo.IDataSetRowDataPageReader;
import kd.data.disf.qing.IDataQingDataProviderCacheParam;

public class IDataSetRowDataPageReaderBuilder {
    private static Log logger = LogFactory.getLog(IDataSetRowDataPageReaderBuilder.class);
    private boolean needColumnToRowTransformation;
    private boolean needDimHierarchy;
    private boolean supressFetchExcceedPageSizeException;
    private int pageSize;
    private IColumnValueConverter<Object, Object[][]> dimGroupConverter;
    private Map<Object, Integer> transKeyMap;
    private Map<String, Integer[]> baseFieldReadWriteIndexs;
    private Map<String, Integer[]> rowKeyDimReadWriteIndexs;
    private List<Integer> hierarchyDimColIndexs;
    private boolean superLongData;
    private Map<String, String> originalDimNumberMap;
    private Map<String, String> rigidConditionDimMemMap;
    protected Set<String> displayNumberDimSet;
    protected Set<Integer> displayNumberIndexSet;

    public IDataSetRowDataPageReaderBuilder(int pageSize, IDataQingDataProviderCacheParam cacheParam) {
        this.pageSize = pageSize;
        this.needDimHierarchy = cacheParam.isNeedDimHierarchy();
        this.needColumnToRowTransformation = cacheParam.isNeedColumnToRowTransformation();
        this.transKeyMap = cacheParam.getTransKeyMap();
        this.hierarchyDimColIndexs = cacheParam.getHierarchyDimColIndexs();
        this.dimGroupConverter = cacheParam.getDimGroupConverter();
        this.baseFieldReadWriteIndexs = cacheParam.getBaseFieldReadWriteIndexs();
        this.rowKeyDimReadWriteIndexs = cacheParam.getRowKeyDimReadWriteIndexs();
        this.superLongData = cacheParam.isSuperLongData();
        this.originalDimNumberMap = cacheParam.getOriginalDimNumberMap();
        this.rigidConditionDimMemMap = cacheParam.getRigidConditionDimMemMap();
        this.supressFetchExcceedPageSizeException = true;
        this.displayNumberDimSet = cacheParam.getDisplayNumberDimSet();
        this.displayNumberIndexSet = cacheParam.getDisplayNumberIndexSet();
    }

    public String toString() {
        return "IDataSetRowDataPageReaderBuilder [needColumnToRowTransformation=" + this.needColumnToRowTransformation + ", needDimHierarchy=" + this.needDimHierarchy + ", supressFetchExcceedPageSizeException=" + this.supressFetchExcceedPageSizeException + ", pageSize=" + this.pageSize + ", dimGroupConverter=" + this.dimGroupConverter + ", transKeyMap=" + this.transKeyMap + ", baseFieldReadWriteIndexs=" + this.baseFieldReadWriteIndexs + ", rowKeyDimReadWriteIndexs=" + this.rowKeyDimReadWriteIndexs + ", hierarchyDimColIndexs=" + this.hierarchyDimColIndexs + ", superLongData=" + this.superLongData + "]";
    }

    public IDataSetRowDataPageReader build() {
        AlgoDataSetDataPageReader reader;
        IDataSetRowDataPageReaderType readerType = IDataSetRowDataPageReaderType.parse(this.needColumnToRowTransformation, this.needDimHierarchy);
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Start build IDataSetRowDataPageReader: readerType=%s, pageSize=%s, needColumnToRowTransformation=%s, needDimHierarchy=%s, baseFieldReadWriteIndexs=%s, rowKeyDimReadWriteIndex=%s, transKeyMap=%s, hierarchyDimColIndexs=%s, dimGroupConverter=%s, superLongData=%s", readerType, this.pageSize, this.needColumnToRowTransformation, this.needDimHierarchy, this.baseFieldReadWriteIndexs, this.rowKeyDimReadWriteIndexs, this.transKeyMap, this.hierarchyDimColIndexs, this.dimGroupConverter, this.superLongData));
        }
        if (this.baseFieldReadWriteIndexs == null || this.baseFieldReadWriteIndexs.isEmpty()) {
            throw new KDBizException("\u57fa\u7840\u6570\u636e\u5b57\u6bb5\u8bfb\u5199\u7684\u7d22\u5f15Map\u4e3a\u7a7a\uff01");
        }
        if (!(readerType != IDataSetRowDataPageReaderType.ColToRow && readerType != IDataSetRowDataPageReaderType.ColToRow_With_Hierarchy || this.rowKeyDimReadWriteIndexs != null && !this.rowKeyDimReadWriteIndexs.isEmpty())) {
            throw new KDBizException("\u6570\u636e\u8bfb\u5199\u7684RowKey\u7ef4\u5ea6\u5b57\u6bb5\u5217\u7d22\u5f15Map\u4e3a\u7a7a\uff01");
        }
        if (this.needDimHierarchy && this.dimGroupConverter == null) {
            throw new KDBizException("\u7ef4\u5ea6\u5c42\u7ea7\u8f6c\u6362\u5668\u4e3a\u7a7a\uff01");
        }
        switch (readerType) {
            case Original: {
                reader = new AlgoDataSetDataPageReader(this.pageSize, this.baseFieldReadWriteIndexs.size() + this.rowKeyDimReadWriteIndexs.size(), this.baseFieldReadWriteIndexs, this.dimGroupConverter, this.rowKeyDimReadWriteIndexs, this.superLongData);
                break;
            }
            case ColToRow: {
                reader = new AlgoDataSetDataPageColToRowReader(this.pageSize, this.rowKeyDimReadWriteIndexs.size() + this.transKeyMap.size() * this.baseFieldReadWriteIndexs.size(), this.baseFieldReadWriteIndexs, this.rowKeyDimReadWriteIndexs, this.transKeyMap, this.dimGroupConverter, this.superLongData);
                break;
            }
            case Original_With_Hierarchy: {
                Iterator<Integer[]> iterator = this.baseFieldReadWriteIndexs.values().iterator();
                int maxWriteIndex = 0;
                while (iterator.hasNext()) {
                    Integer[] next = iterator.next();
                    if (next[1] == null) continue;
                    maxWriteIndex = Math.max(next[1], maxWriteIndex);
                }
                reader = new AlgoDataPageHierarchyReader(this.pageSize, maxWriteIndex + 1, this.baseFieldReadWriteIndexs, this.rowKeyDimReadWriteIndexs, this.dimGroupConverter, this.hierarchyDimColIndexs.toArray(new Integer[0]), this.superLongData, this.originalDimNumberMap, this.rigidConditionDimMemMap);
                break;
            }
            case ColToRow_With_Hierarchy: {
                Iterator<Integer[]> iterator = this.rowKeyDimReadWriteIndexs.values().iterator();
                int maxWriteIndex = 0;
                while (iterator.hasNext()) {
                    Integer[] next = iterator.next();
                    if (next[1] == null) continue;
                    maxWriteIndex = Math.max(next[1], maxWriteIndex);
                }
                reader = new AlgoDataPageHierarchyColToRowReader(this.pageSize, maxWriteIndex + 1 + this.transKeyMap.size() * this.baseFieldReadWriteIndexs.size(), this.baseFieldReadWriteIndexs, this.rowKeyDimReadWriteIndexs, this.transKeyMap, this.dimGroupConverter, this.hierarchyDimColIndexs.toArray(new Integer[0]), this.superLongData, this.originalDimNumberMap, this.rigidConditionDimMemMap);
                break;
            }
            default: {
                return null;
            }
        }
        reader.setSupressFetchExcceedPageSizeException(this.supressFetchExcceedPageSizeException);
        reader.setDisplayNumberDimSet(this.displayNumberDimSet);
        reader.setDisplayNumberIndexSet(this.displayNumberIndexSet);
        return reader;
    }

    public boolean isSupressFetchExcceedPageSizeException() {
        return this.supressFetchExcceedPageSizeException;
    }

    public IDataSetRowDataPageReaderBuilder setSupressFetchExcceedPageSizeException(boolean supressFetchExcceedPageSizeException) {
        this.supressFetchExcceedPageSizeException = supressFetchExcceedPageSizeException;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public IDataSetRowDataPageReaderBuilder setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Map<Object, Integer> getTransKeyMap() {
        return this.transKeyMap;
    }

    public IDataSetRowDataPageReaderBuilder setTransKeyMap(Map<Object, Integer> transKeyMap) {
        this.transKeyMap = transKeyMap;
        return this;
    }

    public boolean isNeedColumnToRowTransformation() {
        return this.needColumnToRowTransformation;
    }

    public IDataSetRowDataPageReaderBuilder setNeedColumnToRowTransformation(boolean needColumnToRowTransformation) {
        this.needColumnToRowTransformation = needColumnToRowTransformation;
        return this;
    }

    public boolean isNeedDimHierarchy() {
        return this.needDimHierarchy;
    }

    public void setNeedDimHierarchy(boolean needDimHierarchy) {
        this.needDimHierarchy = needDimHierarchy;
    }

    public IColumnValueConverter<Object, Object[][]> getDimGroupConverter() {
        return this.dimGroupConverter;
    }

    public void setDimGroupConverter(IColumnValueConverter<Object, Object[][]> dimGroupConverter) {
        this.dimGroupConverter = dimGroupConverter;
    }

    public List<Integer> getHierarchyDimColIndexs() {
        return this.hierarchyDimColIndexs;
    }

    public void setHierarchyDimColIndexs(List<Integer> hierarchyDimColIndexs) {
        this.hierarchyDimColIndexs = hierarchyDimColIndexs;
    }

    public Map<String, Integer[]> getBaseFieldReadWriteIndexs() {
        return this.baseFieldReadWriteIndexs;
    }

    public void setBaseFieldReadWriteIndexs(Map<String, Integer[]> baseFieldReadWriteIndexs) {
        this.baseFieldReadWriteIndexs = baseFieldReadWriteIndexs;
    }

    public Map<String, Integer[]> getRowKeyDimReadWriteIndexs() {
        return this.rowKeyDimReadWriteIndexs;
    }

    public void setRowKeyDimReadWriteIndexs(Map<String, Integer[]> rowKeyDimReadWriteIndexs) {
        this.rowKeyDimReadWriteIndexs = rowKeyDimReadWriteIndexs;
    }

    public boolean isSuperLongData() {
        return this.superLongData;
    }

    public void setSuperLongData(boolean superLongData) {
        this.superLongData = superLongData;
    }

    public static enum IDataSetRowDataPageReaderType implements Serializable
    {
        Original(0, false, false),
        ColToRow(1, true, false),
        Original_With_Hierarchy(2, false, true),
        ColToRow_With_Hierarchy(3, true, true);

        private int code;
        private boolean colToRow;
        private boolean hierarchy;

        private IDataSetRowDataPageReaderType(int code, boolean colToRow, boolean hierarchy) {
            this.code = code;
            this.colToRow = colToRow;
            this.hierarchy = hierarchy;
        }

        public boolean isColToRow() {
            return this.colToRow;
        }

        public boolean isHierarchy() {
            return this.hierarchy;
        }

        public int getCode() {
            return this.code;
        }

        public static IDataSetRowDataPageReaderType parseIntCode(int code) {
            switch (code) {
                case 1: {
                    return ColToRow;
                }
                case 2: {
                    return Original_With_Hierarchy;
                }
                case 3: {
                    return ColToRow_With_Hierarchy;
                }
            }
            return Original;
        }

        public static IDataSetRowDataPageReaderType parse(boolean colToRow, boolean hierarchy) {
            int readerType = 0;
            if (colToRow) {
                readerType = 1;
            }
            return IDataSetRowDataPageReaderType.parseIntCode(readerType + (hierarchy ? 2 : 0));
        }
    }
}

