/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.algo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.SettableArrayRow;
import kd.bos.exception.KDBizException;

public class RawDataToDataSetWrapper
extends AbstractDataSet {
    protected RowMeta rowMeta;
    protected List<Object[]> srcDataList;

    public RawDataToDataSetWrapper(String name, AbstractDataSet srcDataSet, List<Object[]> srcDataList) {
        super(name, srcDataSet.getEnvironment(), srcDataSet);
        this.srcDataList = srcDataList;
        this.rowMeta = srcDataSet.getRowMeta();
    }

    protected InnerRowIterator createIterator() {
        return new SimpleRowIterator(this.rowMeta, this.srcDataList);
    }

    protected RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    public void realClose() {
        if (this.srcDataList != null) {
            this.srcDataList.clear();
        }
    }

    protected static class SimpleRowIterator
    extends InnerRowIterator {
        private Iterator<Object[]> srcDataIterator;
        private SettableArrayRow rowBuffer;

        public SimpleRowIterator(RowMeta rowMeta, Object[][] srcDatas) {
            this(rowMeta, Arrays.asList(srcDatas));
        }

        public SimpleRowIterator(RowMeta rowMeta, Collection<Object[]> srcDataList) {
            if (srcDataList == null) {
                throw new KDBizException("Source Data List is Null!");
            }
            this.srcDataIterator = srcDataList.iterator();
            this.rowBuffer = new SettableArrayRow(rowMeta);
        }

        protected boolean _hasNext() {
            return this.srcDataIterator.hasNext();
        }

        protected Row _next() {
            this.rowBuffer.setValues(this.srcDataIterator.next());
            return this.rowBuffer;
        }
    }
}

