/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.builder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.data.disf.builder.IJsonObjectBuilder;

public interface IDataInstanceBuilderFactory<T>
extends IJsonObjectBuilder {
    public boolean registerClassType(int var1, Class<? extends T> var2);

    public Integer getRegisterClassIndex(Class<? extends T> var1);

    public Class<? extends T> removeRegisterClass(int var1);

    public Class<? extends T> getRegisterClass(int var1);

    public T createFromSource(DynamicObject var1);

    public T createFromSource(JSONArray var1);

    public T createFromSource(JSONObject var1);

    public T createFromSource(String var1);

    public T create(int var1, Object ... var2);

    default public <E> E parseJsonString(String jsonText, Class<E> clazz, Feature ... features) {
        return (E)this.createFromSource(jsonText);
    }

    default public <E extends T> E[] batchCreate(Class<E> targetClassType, DynamicObject[] sourceDynamicObjects) {
        if (targetClassType == null) {
            throw new IllegalArgumentException("Element Class Type cannot be null!");
        }
        return sourceDynamicObjects == null ? (Object[])Array.newInstance(targetClassType, 0) : this.batchCreate(targetClassType, Arrays.asList(sourceDynamicObjects));
    }

    default public <E extends T> E[] batchCreate(Class<E> targetClassType, Collection<DynamicObject> sourceDynamicObjects) {
        int cnt;
        if (targetClassType == null) {
            throw new IllegalArgumentException("Element Class Type cannot be null!");
        }
        if (sourceDynamicObjects == null || (cnt = sourceDynamicObjects.size()) <= 0) {
            return (Object[])Array.newInstance(targetClassType, 0);
        }
        Object[] result = (Object[])Array.newInstance(targetClassType, cnt);
        cnt = 0;
        for (DynamicObject dyn : sourceDynamicObjects) {
            T indicatorBuf = this.createFromSource(dyn);
            if (indicatorBuf == null) continue;
            result[cnt++] = indicatorBuf;
        }
        return Arrays.copyOfRange(result, 0, cnt);
    }

    default public <E extends T> E[] batchCreate(int targetClassTypeCode, DynamicObject[] sourceDynamicObjects) {
        return this.batchCreate(this.getRegisterClass(targetClassTypeCode), sourceDynamicObjects);
    }

    default public <E extends T> E[] batchCreate(int targetClassTypeCode, Collection<DynamicObject> sourceDynamicObjects) {
        return this.batchCreate(this.getRegisterClass(targetClassTypeCode), sourceDynamicObjects);
    }
}

