/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IntArraySequenceBuilder {
    private List<Integer> resultArray;
    private List<MemberStep> stepItems;

    public IntArraySequenceBuilder() {
        this.resultArray = new ArrayList<Integer>();
        this.stepItems = new ArrayList<MemberStep>();
    }

    public IntArraySequenceBuilder(int[] resultArray) {
        this.resultArray = new ArrayList<Integer>(resultArray.length);
        for (int i : resultArray) {
            this.resultArray.add(i);
        }
        this.stepItems = new ArrayList<MemberStep>(resultArray.length);
    }

    public List<Integer> getResultArray() {
        return this.resultArray;
    }

    public IntArraySequenceBuilder addFixedValue(int value) {
        this.stepItems.add(null);
        this.resultArray.add(value);
        return this;
    }

    public IntArraySequenceBuilder setFixedValue(int index, int value) {
        this.stepItems.set(index, null);
        this.resultArray.set(index, value);
        return this;
    }

    public IntArraySequenceBuilder setRangeValue(int index, int start, int end, boolean forward) {
        if (end == start) {
            this.setFixedValue(index, start);
        } else if (forward) {
            this.stepItems.set(index, new ForwardRangeStep(this.resultArray, index, start, end));
        } else {
            this.stepItems.set(index, new BackwardRangeStep(this.resultArray, index, start, end));
        }
        return this;
    }

    public IntArraySequenceBuilder addRangeValue(int start, int end, boolean forward) {
        if (end == start) {
            this.addFixedValue(start);
        } else {
            this.resultArray.add(start);
            if (forward) {
                this.stepItems.add(new ForwardRangeStep(this.resultArray, this.stepItems.size(), start, end));
            } else {
                this.stepItems.add(new BackwardRangeStep(this.resultArray, this.stepItems.size(), start, end));
            }
        }
        return this;
    }

    public IntArraySequenceBuilder setArrayValue(int index, int[] values) {
        if (values.length == 1) {
            this.setFixedValue(index, values[0]);
        } else {
            this.stepItems.set(index, new ArrayStep(this.resultArray, index, values));
        }
        return this;
    }

    public IntArraySequenceBuilder addArrayValue(int[] values) {
        if (values.length == 1) {
            this.addFixedValue(values[0]);
        } else {
            this.resultArray.add(values[0]);
            this.stepItems.add(new ArrayStep(this.resultArray, this.stepItems.size(), values));
        }
        return this;
    }

    public IntArraySequence build() {
        ArrayList<MemberStep> bufList = new ArrayList<MemberStep>(this.stepItems.size());
        for (MemberStep step : this.stepItems) {
            if (step == null) continue;
            bufList.add(step);
        }
        return new IntArraySequence(bufList.toArray(new MemberStep[0]));
    }

    static class ArrayStep
    extends MemberStep {
        private int[] values;
        private int currentIndex = 0;
        private int calcEnd;

        public ArrayStep(List<Integer> resultArray, int resultIndex, int[] values) {
            super(resultArray, resultIndex);
            this.values = values;
            if (values.length <= 0) {
                throw new IllegalArgumentException();
            }
            this.setResult(values[0]);
            this.calcEnd = values.length - 1;
        }

        @Override
        public String toString() {
            return "ArrayStep [values=" + Arrays.toString(this.values) + ", _currentIndex=" + this.currentIndex + ", resultArray=" + this.resultArray + ", resultIndex=" + this.resultIndex + "]";
        }

        @Override
        public boolean next() {
            if (this.currentIndex >= this.calcEnd) {
                this.currentIndex = 0;
                this.setResult(this.values[0]);
                return true;
            }
            this.setResult(this.values[++this.currentIndex]);
            return false;
        }
    }

    static class BackwardRangeStep
    extends ForwardRangeStep {
        public BackwardRangeStep(List<Integer> resultArray, int resultIndex, int start, int end) {
            super(resultArray, resultIndex, start, end);
            this.calcEnd = end >= 0 ? end + 1 : end - 1;
        }

        @Override
        protected void validateRange() {
            if (this.start < this.end) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean next() {
            if (this.currentValue < this.calcEnd) {
                this.currentValue = this.start;
                this.setResult(this.start);
                return true;
            }
            this.setResult(--this.currentValue);
            return false;
        }
    }

    static class ForwardRangeStep
    extends MemberStep {
        protected int start;
        protected int end;
        protected int currentValue;
        protected int calcEnd;

        public ForwardRangeStep(List<Integer> resultArray, int resultIndex, int start, int end) {
            super(resultArray, resultIndex);
            this.finalValidateRange();
            this.start = start;
            this.end = end;
            this.setResult(start);
            this.currentValue = start;
            this.calcEnd = end >= 0 ? end - 1 : end + 1;
        }

        protected void validateRange() {
            if (this.start > this.end) {
                throw new IllegalArgumentException();
            }
        }

        protected final void finalValidateRange() {
            this.validateRange();
        }

        @Override
        public boolean next() {
            if (this.currentValue > this.calcEnd) {
                this.currentValue = this.start;
                this.setResult(this.start);
                return true;
            }
            this.setResult(++this.currentValue);
            return false;
        }
    }

    static abstract class MemberStep {
        protected List<Integer> resultArray;
        protected int resultIndex;

        protected MemberStep(List<Integer> resultArray, int resultIndex) {
            this.resultArray = resultArray;
            this.resultIndex = resultIndex;
        }

        public String toString() {
            return "MemberStep [resultArray=" + this.resultArray + ", resultIndex=" + this.resultIndex + "]";
        }

        protected void setResult(int value) {
            this.resultArray.set(this.resultIndex, value);
        }

        protected abstract boolean next();
    }

    static class IntArraySequence {
        private int states = 0;
        private int rangeSize;
        protected MemberStep[] stepItems;
        protected boolean end = false;

        public IntArraySequence(MemberStep[] stepItems) {
            this.stepItems = stepItems;
            this.rangeSize = stepItems.length - 1;
        }

        public String toString() {
            return "IntArraySequence [stepItems=" + Arrays.toString(this.stepItems) + ", end=" + this.end + "]";
        }

        public boolean next() {
            switch (this.states) {
                case 0: {
                    this.states = this.rangeSize < 0 ? -1 : 1;
                    return true;
                }
                case 1: {
                    if (!this.stepItems[this.rangeSize].next()) {
                        return true;
                    }
                    for (int stepIndex = this.rangeSize - 1; stepIndex >= 0; --stepIndex) {
                        if (this.stepItems[stepIndex].next()) continue;
                        return true;
                    }
                    this.states = -1;
                    return false;
                }
            }
            return false;
        }
    }
}

