/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.builder.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.data.disf.builder.IDataInstanceBuilderFactory;
import kd.data.disf.model.impl.IDataMutableArray;
import kd.data.disf.utils.IDataBeanUtil;
import kd.data.disf.utils.IDataJsonUtil;

public abstract class DataAbstractFactory<T>
implements IDataInstanceBuilderFactory<T> {
    protected IDataMutableArray<Class<? extends T>> elementTypes = new IDataMutableArray<Class>(Class.class);

    protected DataAbstractFactory() {
        this.initFactory();
    }

    protected final void initFactory() {
    }

    @Override
    public boolean registerClassType(int classTypeCode, Class<? extends T> classType) {
        if (classType == null || this.elementTypes.isNotNull(classTypeCode)) {
            return false;
        }
        this.elementTypes.setElementValue(classTypeCode, classType);
        return true;
    }

    @Override
    public Integer getRegisterClassIndex(Class<? extends T> classType) {
        if (classType != null) {
            int i = 0;
            for (Class clazz : (Class[])this.elementTypes.getElementArray()) {
                if (clazz != null && classType.equals(clazz)) {
                    return i;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Class<? extends T> removeRegisterClass(int classTypeCode) {
        return (Class)this.elementTypes.removeByIndex(classTypeCode);
    }

    @Override
    public Class<? extends T> getRegisterClass(int classTypeCode) {
        return (Class)this.elementTypes.getByIndex(classTypeCode);
    }

    protected abstract Integer parseClassType(DynamicObject var1);

    protected abstract Integer parseClassType(JSONArray var1);

    @Override
    public T createFromSource(DynamicObject sourceObject) {
        Integer infoObjectType;
        T result = null;
        if (sourceObject != null && (infoObjectType = this.parseClassType(sourceObject)) != null) {
            result = this.create(infoObjectType, sourceObject);
        }
        return result;
    }

    @Override
    public T createFromSource(JSONArray sourceObject) {
        Integer infoObjectType;
        T result = null;
        if (sourceObject != null && (infoObjectType = this.parseClassType(sourceObject)) != null) {
            result = this.create(infoObjectType, sourceObject);
        }
        return result;
    }

    @Override
    public T createFromSource(String jsonText) {
        if (IDataJsonUtil.isJSonFormat(jsonText, new String[0])) {
            Object obj = JSON.parse((String)jsonText);
            if (obj instanceof JSONArray) {
                return this.createFromSource((JSONArray)obj);
            }
            return this.createFromSource(((JSONObject)obj).getJSONArray("v"));
        }
        return null;
    }

    @Override
    public T createFromSource(JSONObject jsonObject) {
        return this.createFromSource(jsonObject.getJSONArray("v"));
    }

    @Override
    public T create(int classTypeCode, Object ... initParams) {
        Object result = IDataBeanUtil.getClassNewInstance((Class)this.elementTypes.getByIndex(classTypeCode), initParams);
        if (result != null) {
            return this.customizedNewInstance(result, classTypeCode, initParams);
        }
        return null;
    }

    protected abstract T customizedNewInstance(T var1, int var2, Object ... var3);
}

