/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.cacheservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Arrays;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ksql.exception.NotSupportedException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.data.disf.cache.IDataCacheEntry;
import kd.data.disf.cacheservice.IDataCacheService;

public abstract class AbstractDataCacheService<MODEL, PARAM>
implements IDataCacheService<MODEL, PARAM> {
    private static final Log logger = LogFactory.getLog(AbstractDataCacheService.class);
    protected Integer experiedTime;
    protected IDataCacheEntry cacheEntry;
    protected String cacheTypeKeyPrefix;

    protected abstract Class<MODEL> getSerializeClass();

    protected abstract boolean validateDataModel(MODEL var1);

    protected AbstractDataCacheService(IDataCacheEntry cacheEntry, int experiedTime) {
        this.cacheEntry = cacheEntry;
        this.experiedTime = experiedTime;
    }

    public AbstractDataCacheService(IDataCacheEntry cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    protected IDataCacheEntry getCacheEntry() {
        return this.cacheEntry;
    }

    protected String getCacheTypeKeyPrefix() {
        Class<MODEL> clazz;
        if (this.cacheTypeKeyPrefix == null && (clazz = this.getSerializeClass()) != null) {
            this.cacheTypeKeyPrefix = "/" + clazz.getSimpleName() + "/";
        }
        return this.cacheTypeKeyPrefix;
    }

    @Override
    public String buildCacheTypeKey(PARAM param, Object ... keyParams) {
        return this.getCacheTypeKeyPrefix() + String.valueOf(param);
    }

    @Override
    public MODEL reloadCache(PARAM param, Object ... keyParams) {
        return this.loadFromCache(true, param, keyParams);
    }

    @Override
    public MODEL loadFromCache(PARAM param, Object ... keyParams) {
        return this.loadFromCache(false, param, keyParams);
    }

    public MODEL loadFromCache(boolean forceReloadFromResource, PARAM param, Object ... keyParams) {
        String cacheTypeKey = this.buildCacheTypeKey(param, keyParams);
        if (logger.isInfoEnabled()) {
            logger.info(String.format("%s: forceReloadFromResource=%s, m cacheTypeKey=%s, bizDate=%s, keyParams=%s. ", this.getClass().getSimpleName(), forceReloadFromResource, cacheTypeKey, param, Arrays.toString(keyParams)));
        }
        MODEL resultData = null;
        boolean reloadFromDB = true;
        if (!forceReloadFromResource) {
            try {
                String jsonString = this.cacheEntry.get(cacheTypeKey, String.class);
                if (logger.isInfoEnabled()) {
                    logger.info("jsonString=" + jsonString);
                }
                if (StringUtils.isNotEmpty((String)jsonString)) {
                    MODEL MODEL = this.deSerializeToModel(jsonString);
                    resultData = MODEL;
                    if (MODEL != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info("resultData=" + resultData);
                        }
                        reloadFromDB = !this.validateDataModel(resultData);
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (reloadFromDB && !this.isSupportReloadFromResource()) {
            throw new NotSupportedException(String.format("%s: [%s, %s]", "\u4e0d\u652f\u6301\u4ece\u8d44\u6e90\u52a0\u8f7d", cacheTypeKey, Arrays.toString(keyParams)));
        }
        if (reloadFromDB) {
            try {
                resultData = (MODEL)this.reloadFromResource(param, keyParams);
            }
            catch (Exception ex) {
                String msg = "\u4ece\u8d44\u6e90\u52a0\u8f7d\u6570\u636e\u5931\u8d25 : " + ex.getMessage();
                logger.error(msg, (Throwable)ex);
                throw new KDBizException((Throwable)ex, new ErrorCode("rsa_err_7", msg), new Object[0]);
            }
            if (resultData != null) {
                if (this.experiedTime != null) {
                    logger.info("serializeToString=" + this.serializeToString(resultData));
                    this.cacheEntry.put(cacheTypeKey, this.serializeToString(resultData), this.experiedTime);
                } else {
                    this.cacheEntry.put(cacheTypeKey, this.serializeToString(resultData));
                }
            }
        }
        return resultData;
    }

    protected MODEL deSerializeToModel(String jsonString) {
        return (MODEL)JSON.parseObject((String)jsonString, this.getSerializeClass());
    }

    protected String serializeToString(Object source) {
        return JSON.toJSONString((Object)source, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField});
    }

    @Override
    public void removeFromCache(String cacheTypeKey) {
        this.cacheEntry.remove(cacheTypeKey);
    }

    @Override
    public int getExperiedTime() {
        return this.experiedTime;
    }

    @Override
    public void setExperiedTime(int experiedTime) {
        this.experiedTime = experiedTime;
    }

    @Override
    public boolean isSupportReloadFromResource() {
        return true;
    }

    public void setcacheEntry(IDataCacheEntry cacheEntry) {
        this.cacheEntry = cacheEntry;
    }
}

