/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.cacheservice;

import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.data.disf.cache.DistributeCache;
import kd.data.disf.cache.IDataCacheEntry;
import kd.data.disf.cache.IDataCacheHelper;
import kd.data.disf.cache.IDataCacheModule;
import kd.data.disf.cacheservice.AbstractDataCacheService;
import kd.data.disf.cacheservice.IDataCacheMgr;
import kd.data.disf.cacheservice.IDataCacheService;
import kd.data.disf.fetcher.impl.ObjectClassTypeFetcher;
import kd.data.disf.model.impl.IDataBaseMutableArrayMap;
import kd.data.disf.utils.IDataDateUtil;
import kd.data.disf.utils.IDataStringUtil;

public abstract class IDataAbstractCacheMgr
implements IDataCacheMgr {
    protected IDataBaseMutableArrayMap<Class, IDataCacheService> cacheServiceInstanceMap;
    protected DistributeCache distributeCahce;
    private static final int Default_Cache_Experied_Time = 120;
    protected int experiedTime;
    protected boolean forceReload = true;

    protected abstract IDataCacheModule getAppCacheRegionKey();

    protected IDataAbstractCacheMgr() {
        this(120);
    }

    protected IDataAbstractCacheMgr(int experiedTime) {
        this.experiedTime = experiedTime;
        this.cacheServiceInstanceMap = new IDataBaseMutableArrayMap(IDataCacheService.class, ObjectClassTypeFetcher.instance());
        this.cacheServiceInstanceMap.flushCacheToArray();
        this.initCache();
    }

    protected final void initCache() {
        this.distributeCahce = IDataCacheHelper.getDistributeCache(this.getAppCacheRegionKey());
        this.initCacheMgr();
    }

    protected abstract void initCacheMgr();

    protected void registerCacheService(IDataCacheService cacheServiceInstance) {
        if (cacheServiceInstance == null) {
            return;
        }
        this.cacheServiceInstanceMap.addValue(cacheServiceInstance.getClass(), cacheServiceInstance);
    }

    protected void registerCacheService(Class<? extends AbstractDataCacheService> cacheServiceInstanceClassType) {
        if (cacheServiceInstanceClassType == null) {
            return;
        }
        try {
            this.cacheServiceInstanceMap.addValue(cacheServiceInstanceClassType, cacheServiceInstanceClassType.getConstructor(IDataCacheEntry.class, Integer.TYPE).newInstance(this.distributeCahce, this.experiedTime));
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", IDataStringUtil.printStackTraceToString(ex)), new Object[0]);
        }
    }

    public String getCurrentUserCacheKey() {
        return this.getCurrentUserCacheKey(IDataDateUtil.dateToString(IDataDateUtil.getCurrentDate()));
    }

    public String getCurrentUserCacheKey(Object suffix) {
        return RequestContext.get().getUserId() + "_" + suffix;
    }

    @Override
    public <T extends IDataCacheService> T getDataCacheService(Class<T> classType) {
        return (T)this.cacheServiceInstanceMap.get(classType);
    }

    public <T extends IDataCacheService> T getDataCacheServiceByIndex(int index) {
        return (T)this.cacheServiceInstanceMap.getByIndex(index);
    }

    @Override
    public boolean hasDataCacheMgr(Class dataCacheMgrClassType) {
        return this.cacheServiceInstanceMap.contain(dataCacheMgrClassType);
    }
}

