/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.date;

import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import kd.bos.ksql.exception.NotSupportedException;
import kd.data.disf.date.IDatePeriod;
import kd.data.disf.date.IPeriodRangeProvider;
import kd.data.disf.enums.TimePeriodTypeEnum;
import kd.data.disf.utils.IDataDateUtil;

public class CalendarDatePeriod
implements IDatePeriod,
IPeriodRangeProvider {
    private TimePeriodTypeEnum periodType;
    private Date currentDate;
    protected int periodDayCount;
    protected int inPeridDays;
    protected Date startDate;
    protected Date endDate;

    protected CalendarDatePeriod(TimePeriodTypeEnum periodType) {
        this(periodType, new Date());
    }

    protected CalendarDatePeriod(TimePeriodTypeEnum periodType, Date date) {
        this.periodType = periodType;
        this.currentDate = date;
    }

    public String toString() {
        return "CalendarDatePeriod [periodType=" + this.periodType + ", currentDate=" + this.currentDate + ", periodDayCount=" + this.periodDayCount + ", inPeridDays=" + this.inPeridDays + ", startDate=" + this.startDate + ", endDate=" + this.endDate + "]";
    }

    public static CalendarDatePeriod getInstance(TimePeriodTypeEnum periodType, Date date) {
        return CalendarDatePeriod.updateCalendarDatePeriod(periodType, date, null);
    }

    public static CalendarDatePeriod updateCalendarDatePeriod(Date date, CalendarDatePeriod updateTarget) {
        return CalendarDatePeriod.updateCalendarDatePeriod(null, date, updateTarget);
    }

    public void updateCalendarDatePeriod(Date date) {
        CalendarDatePeriod.updateCalendarDatePeriod(date, this);
    }

    public static CalendarDatePeriod updateCalendarDatePeriod(TimePeriodTypeEnum periodType, int periodLength, int offset, Date date, CalendarDatePeriod updateTarget) {
        if (periodType == null && updateTarget == null) {
            throw new IllegalArgumentException("Period Type and Update Target cannot both be n ull!");
        }
        if (periodLength <= 0) {
            throw new IllegalArgumentException("Period Length cannot less than 1!");
        }
        if (periodType == null) {
            throw new IllegalArgumentException("Period Type cannot be null!");
        }
        if (date == null) {
            date = IDataDateUtil.getCurrentDate();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (updateTarget == null) {
            updateTarget = new CalendarDatePeriod(periodType, date);
        } else {
            updateTarget.startDate = null;
            updateTarget.endDate = null;
            updateTarget.currentDate = date;
            updateTarget.periodType = periodType;
        }
        boolean monthBasePeriod = true;
        switch (periodType) {
            case Day: {
                monthBasePeriod = false;
                if (periodLength != 1 || offset != 0) break;
                updateTarget.startDate = date;
                updateTarget.endDate = date;
                updateTarget.periodDayCount = 1;
                updateTarget.inPeridDays = 1;
                updateTarget.currentDate = date;
                updateTarget.periodType = periodType;
                return updateTarget;
            }
            case Month: {
                break;
            }
            case Quarter: {
                periodLength *= 3;
                break;
            }
            case HalfYear: {
                periodLength *= 6;
                break;
            }
            case Year: {
                periodLength *= 12;
                break;
            }
            default: {
                monthBasePeriod = false;
            }
        }
        int[][] periodDays = new int[2][3];
        for (int i = 0; i < periodDays.length; ++i) {
            int[] period = periodDays[i];
            switch (periodType) {
                case Day: {
                    if (i == 0) {
                        calendar.add(6, offset * periodLength);
                        break;
                    }
                    calendar.add(6, periodLength - 1);
                    break;
                }
                case Week: {
                    if (i == 0) {
                        calendar.add(6, -1 * (calendar.get(7) - 1));
                        calendar.add(3, offset * periodLength);
                        break;
                    }
                    calendar.add(3, periodLength);
                    break;
                }
                case Month: 
                case Quarter: 
                case HalfYear: 
                case Year: {
                    if (i == 0) {
                        switch (periodType) {
                            case Quarter: {
                                calendar.set(2, (calendar.get(2) + 1) / 4 * 3);
                                break;
                            }
                            case HalfYear: {
                                calendar.set(2, (calendar.get(2) + 1) / 6 * 6);
                                break;
                            }
                            case Year: {
                                calendar.set(2, 0);
                            }
                        }
                        calendar.set(5, 1);
                        calendar.add(2, offset * periodLength);
                        break;
                    }
                    calendar.add(2, -(periodLength - 1));
                    break;
                }
                default: {
                    throw new NotSupportedException(String.format("CalendarDatePeriod Not Support [%s] Period Type", periodType));
                }
            }
            period[1] = calendar.get(2);
            period[2] = calendar.get(1);
            if (i == 0) {
                period[0] = monthBasePeriod ? calendar.getActualMaximum(5) : calendar.get(5);
                calendar.set(period[2], period[1], period[0], 23, 59, 59);
                updateTarget.endDate = calendar.getTime();
                continue;
            }
            period[0] = monthBasePeriod ? 1 : calendar.get(5);
            calendar.set(period[2], period[1], period[0], 0, 0, 0);
            updateTarget.startDate = calendar.getTime();
        }
        updateTarget.periodDayCount = TimePeriodTypeEnum.Day == periodType ? periodLength : (int)ChronoUnit.DAYS.between(updateTarget.startDate.toInstant(), updateTarget.endDate.toInstant()) + 1;
        updateTarget.inPeridDays = (int)ChronoUnit.DAYS.between(updateTarget.startDate.toInstant(), date.toInstant()) + 1;
        return updateTarget;
    }

    public static CalendarDatePeriod updateCalendarDatePeriod(TimePeriodTypeEnum periodType, Date date, CalendarDatePeriod updateTarget) {
        int currentDay;
        int endYear;
        if (periodType == null && updateTarget == null) {
            throw new IllegalArgumentException("Period Type and Update Target cannot both be n ull!");
        }
        if (periodType == null && date == null) {
            return updateTarget;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (updateTarget == null) {
            updateTarget = new CalendarDatePeriod(periodType, date);
        } else {
            updateTarget.currentDate = date;
            if (periodType == null) {
                periodType = updateTarget.periodType;
            } else {
                updateTarget.periodType = periodType;
            }
        }
        int startDay = 1;
        int startYear = endYear = calendar.get(1);
        int currentMonth = calendar.get(2);
        int endDay = currentDay = calendar.get(5);
        int startMonth = currentMonth;
        int endMonth = currentMonth;
        block0 : switch (periodType) {
            case Week: {
                calendar.add(6, -1 * (calendar.get(7) - 1));
                startDay = calendar.get(5);
                startMonth = calendar.get(2);
                startYear = calendar.get(1);
                calendar.add(6, 6);
                endMonth = calendar.get(2);
                endDay = calendar.get(5);
                endYear = calendar.get(1);
                break;
            }
            case Month: {
                startDay = calendar.getActualMinimum(5);
                endDay = calendar.getActualMaximum(5);
                break;
            }
            case Quarter: {
                int quarer = (currentMonth + 1) / 4;
                startMonth = quarer * 3;
                endMonth = quarer * 3 + 2;
                switch (quarer) {
                    case 0: 
                    case 3: {
                        endDay = 31;
                        break block0;
                    }
                }
                endDay = 30;
                break;
            }
            case HalfYear: {
                startMonth = currentMonth / 6;
                endMonth = startMonth * 6 + 5;
                switch (startMonth) {
                    case 0: {
                        endDay = 30;
                        break;
                    }
                    case 1: {
                        endDay = 31;
                    }
                }
                break;
            }
            case Year: {
                startMonth = 0;
                endMonth = 11;
                endDay = 31;
                break;
            }
            default: {
                throw new NotSupportedException(String.format("CalendarDatePeriod Not Support [%s] Period Type", periodType));
            }
        }
        calendar.set(startYear, startMonth, startDay, 0, 0, 0);
        updateTarget.startDate = calendar.getTime();
        calendar.set(endYear, endMonth, endDay, 23, 59, 59);
        updateTarget.endDate = calendar.getTime();
        updateTarget.periodDayCount = (int)ChronoUnit.DAYS.between(updateTarget.startDate.toInstant(), updateTarget.endDate.toInstant()) + 1;
        updateTarget.inPeridDays = (int)ChronoUnit.DAYS.between(updateTarget.startDate.toInstant(), date.toInstant()) + 1;
        return updateTarget;
    }

    @Override
    public IDatePeriod getPeriodByOffset(int offset) {
        if (offset == 0) {
            return this;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.currentDate);
        switch (this.periodType) {
            case Week: {
                calendar.add(3, offset);
                break;
            }
            case Month: {
                calendar.add(2, offset);
                break;
            }
            case Quarter: {
                calendar.add(2, offset * 3);
                break;
            }
            case HalfYear: {
                calendar.add(2, offset * 6);
                break;
            }
            case Year: {
                calendar.add(1, offset);
                break;
            }
            default: {
                throw new NotSupportedException(String.format("CalendarDatePeriod Not Support [%s] Period Type", this.periodType));
            }
        }
        return CalendarDatePeriod.getInstance(this.periodType, calendar.getTime());
    }

    @Override
    public IDatePeriod getPeriod(TimePeriodTypeEnum periodType, Date sourceDate) {
        return CalendarDatePeriod.getInstance(periodType, sourceDate);
    }

    @Override
    public int getPeriodDayCount() {
        return this.periodDayCount;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public TimePeriodTypeEnum getPeriodType() {
        return this.periodType;
    }

    protected void setPeriodType(TimePeriodTypeEnum periodType) {
        this.periodType = periodType;
    }

    @Override
    public Date getCurrentDate() {
        return this.currentDate;
    }

    @Override
    public int getInPeridDays() {
        return this.inPeridDays;
    }

    protected void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }
}

