/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.enums;

import kd.data.disf.enums.IByteCodeEnum;

public enum IDataNumberCardinalityEnum implements IByteCodeEnum<IDataNumberCardinalityEnum>
{
    One(0),
    Tens(1),
    Hundreds(2),
    Thousands(3),
    Tens_Of_Thousands(4),
    Hundreds_Of_Thousands(5),
    Millions(6),
    Tens_Of_Millions(7),
    Hundreds_Of_Millions(8),
    Billion(9),
    Tens_Of_Billion(10),
    Hundreds_Of_Billion(11),
    Trillions(12),
    Tens_Of_Trillions(13),
    Hundreds_Of_Trillions(14),
    Quadrillion(15);

    private byte code;
    public static final int length = 4;

    private IDataNumberCardinalityEnum(byte code) {
        this.code = code;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    public static IDataNumberCardinalityEnum getEnum(Byte code) {
        if (code == null) {
            return null;
        }
        switch (code) {
            case 0: {
                return One;
            }
            case 1: {
                return Tens;
            }
            case 2: {
                return Hundreds;
            }
            case 3: {
                return Thousands;
            }
            case 4: {
                return Tens_Of_Thousands;
            }
            case 5: {
                return Hundreds_Of_Thousands;
            }
            case 6: {
                return Millions;
            }
            case 7: {
                return Tens_Of_Millions;
            }
            case 8: {
                return Hundreds_Of_Millions;
            }
            case 9: {
                return Billion;
            }
            case 10: {
                return Tens_Of_Billion;
            }
            case 11: {
                return Hundreds_Of_Billion;
            }
            case 12: {
                return Trillions;
            }
            case 13: {
                return Tens_Of_Trillions;
            }
            case 14: {
                return Hundreds_Of_Trillions;
            }
            case 15: {
                return Quadrillion;
            }
        }
        return null;
    }

    public String getSuffixZeroString() {
        return IDataNumberCardinalityEnum.getSuffixZeroString(this.code);
    }

    public static String getSuffixZeroString(int cardinalityCode) {
        switch (cardinalityCode) {
            case 1: {
                return "0";
            }
            case 2: {
                return "00";
            }
            case 3: {
                return "000";
            }
            case 4: {
                return "0000";
            }
            case 5: {
                return "00000";
            }
            case 6: {
                return "000000";
            }
            case 7: {
                return "0000000";
            }
            case 8: {
                return "00000000";
            }
            case 9: {
                return "000000000";
            }
            case 10: {
                return "0000000000";
            }
            case 11: {
                return "00000000000";
            }
            case 12: {
                return "000000000000";
            }
            case 13: {
                return "0000000000000";
            }
            case 14: {
                return "00000000000000";
            }
            case 15: {
                return "000000000000000";
            }
        }
        return "";
    }

    public static IDataNumberCardinalityEnum getEnum(String code) {
        return code == null ? null : IDataNumberCardinalityEnum.getEnum(Byte.valueOf(code));
    }

    @Override
    public IDataNumberCardinalityEnum parse(Byte code) {
        return IDataNumberCardinalityEnum.getEnum(code);
    }
}

