/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.data.disf.excel.ExceedRowCntException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IDataExcelReader {
    private static final Log logger = LogFactory.getLog(IDataExcelReader.class);
    protected XSSFReader xsfReader;
    protected InputStream inputStream;
    protected Set<String> sheetNameList;
    protected String fileUrl;

    public IDataExcelReader(InputStream inputStream) throws IOException, OpenXML4JException {
        this.reset(inputStream);
    }

    public IDataExcelReader(String fileUrl) throws IOException, OpenXML4JException {
        this.fileUrl = fileUrl;
        if (this.fileUrl != null) {
            this.reset(FileServiceFactory.getAttachmentFileService().getInputStream(fileUrl));
        }
    }

    public final void reset(InputStream inputStream) throws IOException, OpenXML4JException {
        this.inputStream = inputStream;
        if (this.inputStream != null) {
            this.xsfReader = new XSSFReader(OPCPackage.open((InputStream)inputStream));
            XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)this.xsfReader.getSheetsData();
            this.sheetNameList = new LinkedHashSet<String>(10);
            while (sheetIterator.hasNext()) {
                sheetIterator.next();
                this.sheetNameList.add(sheetIterator.getSheetName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(SheetHandler sheetHandler, String ... processSheetNames) throws InvalidFormatException, IOException, SAXException {
        ArrayList parts;
        if (sheetHandler == null) {
            return;
        }
        HashSet<String> filterNames = new HashSet<String>();
        if (processSheetNames != null && processSheetNames.length > 0) {
            for (String name : processSheetNames) {
                if (!StringUtils.isNotEmpty((String)name)) continue;
                filterNames.add(name);
            }
        }
        boolean enableSheetNameFilter = !filterNames.isEmpty();
        InputStream sharedStringsData = this.xsfReader.getSharedStringsData();
        try (OPCPackage open = OPCPackage.open((InputStream)sharedStringsData);){
            parts = open.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        }
        sheetHandler.setSharedStringsTable(new SharedStringsTable((PackagePart)parts.get(0)));
        sheetHandler.setStylesTable(this.xsfReader.getStylesTable());
        sheetHandler.setSheetNames(filterNames);
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        parser.setContentHandler((ContentHandler)sheetHandler);
        XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)this.xsfReader.getSheetsData();
        while (sheetIterator.hasNext()) {
            InputStream sheet = sheetIterator.next();
            String curSheetName = sheetIterator.getSheetName();
            if (enableSheetNameFilter && !filterNames.contains(curSheetName)) continue;
            sheetHandler.setSheetName(curSheetName);
            try {
                parser.parse(new InputSource(sheet));
            }
            catch (ExceedRowCntException ex1) {
                sheetHandler.setInterrupt(true);
            }
            finally {
                sheet.close();
            }
            if (!sheetHandler.isInterrupt()) continue;
            return;
        }
    }

    public static List<String> getExcelSheetNames(InputStream in) throws IOException, OpenXML4JException {
        if (in == null) {
            return new LinkedList<String>();
        }
        ArrayList<String> sheetNames = new ArrayList<String>(10);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)new XSSFReader(OPCPackage.open((InputStream)in)).getSheetsData();
        while (sheets.hasNext()) {
            sheets.next();
            sheetNames.add(sheets.getSheetName());
        }
        return sheetNames;
    }

    public XSSFReader getXsfReader() {
        return this.xsfReader;
    }

    public Set<String> getSheetNameList() {
        return this.sheetNameList;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

