/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.fetcher.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import kd.data.disf.fetcher.IElementKeyFetcher;
import kd.data.disf.utils.IDataBeanUtil;
import kd.data.disf.utils.IDataJsonArraySerialization;
import kd.data.disf.utils.IDataValueUtil;

public class EmptyElementKeyFetcher<K, V>
implements IElementKeyFetcher<K, V>,
IDataJsonArraySerialization {
    private static final long serialVersionUID = -78279054600199633L;
    @JSONField(serialize=false)
    @JsonIgnore
    private Class<K> keyClassType;
    private Constructor<K> constrcutor;

    public EmptyElementKeyFetcher() {
    }

    public EmptyElementKeyFetcher(Class<K> keyClassType) {
        this.keyClassType = keyClassType;
        try {
            this.constrcutor = IDataBeanUtil.getConstructor(keyClassType, String.class);
        }
        catch (Exception ex) {
            this.constrcutor = null;
        }
    }

    @Override
    public K[] getKey(V val) {
        throw new IllegalArgumentException("Not Support ! value=" + val);
    }

    @Override
    public K stringToKey(String keyString) {
        if (this.constrcutor != null) {
            try {
                return this.constrcutor.newInstance(keyString);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new IllegalArgumentException("Not Support ! value=" + keyString, e);
            }
        }
        throw new IllegalArgumentException("Not Support ! value=" + keyString);
    }

    @Override
    public boolean supportStringToKey() {
        return this.constrcutor != null;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Class<K> getKeyClassType() {
        return this.keyClassType;
    }

    public void setKeyClassType(Class<K> keyClassType) {
        this.keyClassType = keyClassType;
    }

    @Override
    public Object[] getV() {
        return new Object[]{this.getClass().getName(), this.keyClassType.getName()};
    }

    @Override
    public void setV(Object[] v) {
        this.keyClassType = IDataBeanUtil.getClassByName(IDataValueUtil.getString(v, 1));
    }
}

