/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.file;

import java.io.File;

public class BaseMultipleVolumeFileInfo {
    protected String fileNameTemplate;
    protected File curFileName;
    protected int volumeCnt;
    protected long volumnSize;
    protected long currentVolumnSize;
    protected long totalVolumnSize;

    public BaseMultipleVolumeFileInfo(String fileNameTemplate, long volumnSize) {
        this.reset(fileNameTemplate, volumnSize);
    }

    public BaseMultipleVolumeFileInfo(File fileTemplate, long volumnSize) {
        this.reset(fileTemplate, volumnSize);
    }

    public final void reset(File fileTemplate, long volumnSize) {
        this.reset(BaseMultipleVolumeFileInfo.createFileTemplateName(fileTemplate), volumnSize);
    }

    public final void reset(String fileTemplate, long volumnSize) {
        this.volumnSize = volumnSize;
        this.volumeCnt = 0;
        this.currentVolumnSize = 0L;
        this.totalVolumnSize = 0L;
        this.fileNameTemplate = fileTemplate;
    }

    public static String createFileTemplateName(File fileTemplate) {
        int suffixPos;
        StringBuilder buf = new StringBuilder();
        String nameBuf = fileTemplate.getParent();
        buf.append(nameBuf);
        if (!nameBuf.endsWith(File.separator)) {
            buf.append(File.separator);
        }
        if ((suffixPos = (nameBuf = fileTemplate.getName()).lastIndexOf(46)) > 0) {
            buf.append(nameBuf.substring(0, suffixPos)).append("_%d").append(nameBuf.substring(suffixPos, nameBuf.length()));
        } else {
            buf.append(nameBuf).append("_%d");
        }
        return buf.toString();
    }

    public String toString() {
        return "MultipleVolumeFileInfo [fileNameTemplate=" + this.fileNameTemplate + ", curFileName=" + this.curFileName + ", volumeCnt=" + this.volumeCnt + ", volumnSize=" + this.volumnSize + ", currentVolumnSize=" + this.currentVolumnSize + ", totalVolumnSize=" + this.totalVolumnSize + "]";
    }

    public boolean needStartNewVolume() {
        return this.currentVolumnSize > this.volumnSize;
    }

    public File switchToNewVolume() {
        this.currentVolumnSize = 0L;
        this.curFileName = new File(String.format(this.fileNameTemplate, ++this.volumeCnt));
        return this.curFileName;
    }

    public boolean increaseCurrentVolumnSize(long addSize) {
        this.totalVolumnSize += addSize;
        return (this.currentVolumnSize += addSize) > this.volumnSize;
    }

    public String getFileNameTemplate() {
        return this.fileNameTemplate;
    }

    public void setFileNameTemplate(String fileNameTemplate) {
        this.fileNameTemplate = fileNameTemplate;
    }

    public long getVolumnSize() {
        return this.volumnSize;
    }

    public void setVolumnSize(int volumnSize) {
        this.volumnSize = volumnSize;
    }

    public File getCurFileName() {
        return this.curFileName;
    }

    public int getVolumeCnt() {
        return this.volumeCnt;
    }

    public long getCurrentVolumnSize() {
        return this.currentVolumnSize;
    }

    public long getTotalVolumnSize() {
        return this.totalVolumnSize;
    }
}

