/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.iterators.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kd.data.disf.model.impl.IDataMapEntry;

public class ArrayEntryIterator<E>
implements Iterator<Map.Entry<Integer, E>> {
    private E[] sourceArray;
    private int pos;
    private int size;
    private IDataMapEntry<Integer, E> currentRow = new IDataMapEntry();

    public ArrayEntryIterator(E[] array) {
        this.reset(array);
    }

    @Override
    public Map.Entry<Integer, E> next() {
        if (this.pos < this.size) {
            this.currentRow.reset(this.pos, this.sourceArray[this.pos]);
            ++this.pos;
            return this.currentRow;
        }
        throw new NoSuchElementException("No more elements: " + this.pos + " / " + this.size);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.size;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final void reset(E[] array) {
        this.sourceArray = array;
        this.pos = 0;
        this.size = array != null ? array.length : -1;
    }
}

