/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.iterators.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<E>
implements Iterator<E> {
    private E[] sourceArray;
    private int pos;
    private int size;

    public ArrayIterator(E[] array) {
        this.reset(array);
    }

    @Override
    public E next() {
        if (this.pos < this.size) {
            return this.sourceArray[this.pos++];
        }
        throw new NoSuchElementException("No more elements: " + this.pos + " / " + this.size);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.size;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final void reset(E[] array) {
        this.sourceArray = array;
        this.size = array != null ? array.length : -1;
        this.pos = 0;
    }

    public void reset() {
        this.pos = 0;
    }
}

