/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.iterators.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kd.data.disf.model.impl.IDataMapEntry;

public class ArrayMapEntryIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private V[] sourceArray;
    private Object[] indexKeyArray;
    private IDataMapEntry<K, V> currentEntry;
    private int pos;
    private int limitSize;

    public ArrayMapEntryIterator(V[] array, Map<K, Integer> indexMap) {
        this(array, indexMap, 0, Integer.MAX_VALUE);
    }

    public ArrayMapEntryIterator(V[] array, Map<K, Integer> indexMap, int startPos, int limitLength) {
        this.reset(array, indexMap, startPos, limitLength);
    }

    @Override
    public Map.Entry<K, V> next() {
        if (this.pos < this.limitSize) {
            return this.currentEntry.reset(this.indexKeyArray[this.pos], this.sourceArray[this.pos++]);
        }
        throw new NoSuchElementException("No more elements: " + this.pos + " / " + this.limitSize);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.limitSize;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final void reset(V[] array, Map<K, Integer> indexMap, int startPos, int limitLength) {
        int srcArraySize;
        this.sourceArray = array;
        this.pos = 0;
        if (array != null && (srcArraySize = array.length) > 0 && startPos < srcArraySize) {
            this.limitSize = srcArraySize > startPos + limitLength ? startPos + limitLength : srcArraySize;
            this.indexKeyArray = new Object[srcArraySize];
            if (indexMap != null && !indexMap.isEmpty()) {
                for (Map.Entry<K, Integer> en : indexMap.entrySet()) {
                    this.indexKeyArray[en.getValue().intValue()] = en.getKey();
                }
            }
            this.currentEntry = new IDataMapEntry();
        } else {
            this.limitSize = 0;
        }
    }

    public Map.Entry<K, V>[] getEntriesArray() {
        IDataMapEntry[] result = new IDataMapEntry[this.limitSize];
        for (int i = 0; i < this.limitSize; ++i) {
            result[i] = new IDataMapEntry<Object, V>(this.indexKeyArray[i], this.sourceArray[i]);
        }
        return result;
    }

    public int getPos() {
        return this.pos;
    }

    public int getLimitSize() {
        return this.limitSize;
    }
}

