/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.iterators.impl;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import kd.data.disf.model.impl.IDataMapEntry;

public class ArrayMapMultiKeyEntryIterator<K, V>
implements Iterator<Map.Entry<K[], V>> {
    private V[] sourceArray;
    private K[][] indexKeyArray;
    private Class<K> keyClassType;
    private IDataMapEntry<K[], V> currentEntry;
    private int pos;
    private int limitSize;

    public ArrayMapMultiKeyEntryIterator(V[] array, Map<K, Integer> indexMap, Class<K> keyClassType) {
        this(array, indexMap, keyClassType, 0, Integer.MAX_VALUE);
    }

    public ArrayMapMultiKeyEntryIterator(V[] array, Map<K, Integer> indexMap, Class<K> keyClassType, int startPos, int limitLength) {
        this.keyClassType = keyClassType;
        this.reset(array, indexMap, startPos, limitLength);
    }

    @Override
    public Map.Entry<K[], V> next() {
        if (this.pos < this.limitSize) {
            return this.currentEntry.reset((K[][])this.indexKeyArray[this.pos], this.sourceArray[this.pos++]);
        }
        throw new NoSuchElementException("No more elements: " + this.pos + " / " + this.limitSize);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.limitSize;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public final void reset(V[] array, Map<K, Integer> indexMap, int startPos, int limitLength) {
        int srcArraySize;
        this.sourceArray = array;
        this.pos = startPos;
        if (array != null && (srcArraySize = array.length) > 0 && startPos < srcArraySize) {
            this.limitSize = srcArraySize > startPos + limitLength ? startPos + limitLength : srcArraySize;
            LinkedList[] bufIndexKeyArray = (LinkedList[])Array.newInstance(LinkedList.class, srcArraySize);
            this.indexKeyArray = (Object[][])Array.newInstance(this.getKeyClassType(), this.limitSize, 0);
            if (indexMap != null && !indexMap.isEmpty()) {
                for (Map.Entry<K, Integer> en : indexMap.entrySet()) {
                    LinkedList<K> keyList = bufIndexKeyArray[en.getValue()];
                    if (keyList == null) {
                        bufIndexKeyArray[en.getValue().intValue()] = keyList = new LinkedList<K>();
                    }
                    keyList.add(en.getKey());
                }
                for (int i = 0; i < this.limitSize; ++i) {
                    if (bufIndexKeyArray[i] == null) continue;
                    this.indexKeyArray[i] = bufIndexKeyArray[i].toArray((Object[])Array.newInstance(this.keyClassType, 0));
                }
            }
            this.currentEntry = new IDataMapEntry();
        } else {
            this.limitSize = 0;
        }
    }

    public Map.Entry<K[], V>[] getEntriesArray() {
        IDataMapEntry[] result = new IDataMapEntry[this.limitSize];
        for (int i = 0; i < this.limitSize; ++i) {
            result[i] = new IDataMapEntry<K[], V>(this.indexKeyArray[i], this.sourceArray[i]);
        }
        return result;
    }

    public Class<K> getKeyClassType() {
        return this.keyClassType;
    }

    public int getPos() {
        return this.pos;
    }

    public int getLimitSize() {
        return this.limitSize;
    }
}

