/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.iterators.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;

public class ClassPropertyValueIterator<E>
implements Iterator<E> {
    protected Object[] srcObjectArray;
    protected Collection<?> sourceCollection;
    protected Method targetMethod;
    protected Iterator<?> srcIterator;
    protected boolean isArrayType;
    protected boolean suppressGetValueError = false;

    public ClassPropertyValueIterator(Object[] srcObjectArray, String methodName) {
        if (srcObjectArray == null) {
            throw new IllegalArgumentException("Source Object Array is null!");
        }
        this.targetMethod = this.getMethodFromFirstValidObject(srcObjectArray, methodName);
        this.srcObjectArray = srcObjectArray;
        this.isArrayType = true;
        this.srcIterator = this.getIterator();
    }

    public ClassPropertyValueIterator(Collection<?> sourceCollection, Class<?> elementClassType, String methodName) {
        if (sourceCollection == null) {
            throw new IllegalArgumentException("Source Object Collection is null!");
        }
        if (elementClassType == null) {
            throw new IllegalArgumentException("Source Element Class Type is null!");
        }
        try {
            this.targetMethod = elementClassType.getMethod(methodName, new Class[0]);
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", String.format("Method Name[%s] not found! Error Detail: %s", methodName, ex.getMessage())), new Object[0]);
        }
        this.sourceCollection = sourceCollection;
        this.isArrayType = false;
        this.srcIterator = this.getIterator();
    }

    protected final Iterator getIterator() {
        if (this.isArrayType) {
            return Arrays.asList(this.srcObjectArray).iterator();
        }
        return this.sourceCollection.iterator();
    }

    protected final Method getMethodFromFirstValidObject(Object[] srcObjectArray, String methodName) {
        if (srcObjectArray != null && srcObjectArray.length > 0 && StringUtils.isEmpty((String)methodName)) {
            for (Object obj : srcObjectArray) {
                if (obj == null) continue;
                try {
                    return obj.getClass().getMethod(methodName, new Class[0]);
                }
                catch (Exception ex) {
                    throw new KDBizException((Throwable)ex, new ErrorCode("", String.format("Method Name[%s] not found! Error Detail: %s", methodName, ex.getMessage())), new Object[0]);
                }
            }
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.srcIterator.hasNext();
    }

    @Override
    public E next() {
        try {
            Object objBuf = this.srcIterator.next();
            if (objBuf == null) {
                return null;
            }
            return (E)this.targetMethod.invoke(objBuf, new Object[0]);
        }
        catch (Exception ex) {
            if (this.suppressGetValueError) {
                return null;
            }
            throw new KDBizException((Throwable)ex, new ErrorCode("", String.format("Error on Access Method [%s]! Error Detail: %s", this.targetMethod.getName(), ex.getMessage())), new Object[0]);
        }
    }

    public void resetIterator() {
        this.srcIterator = this.getIterator();
    }
}

