/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.iterators.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kd.data.disf.model.impl.IntSizeBitSet;

public class IntSizeBitSetIterator
implements Iterator<Integer> {
    private IntSizeBitSet source;
    private boolean unlimited;
    private int limitSize;
    private int currentIndex = -1;
    private boolean hasNext;
    private boolean needInvokeHasNext;

    public IntSizeBitSetIterator(IntSizeBitSet bitset, int limit) {
        this.reset(bitset, limit);
    }

    public final void reset(IntSizeBitSet source, int limitSize) {
        this.source = source;
        this.hasNext = this.source != null && !source.isEmpty() && (this.limitSize = limitSize) != 0;
        this.unlimited = limitSize < 0;
        this.currentIndex = -1;
        this.needInvokeHasNext = true;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext && this.needInvokeHasNext) {
            this.hasNext = (this.unlimited || this.limitSize > 0) && (this.currentIndex = this.source.nextSetBit(this.currentIndex + 1)) >= 0;
            this.needInvokeHasNext = !this.hasNext;
        }
        return this.hasNext;
    }

    @Override
    public Integer next() {
        if (this.needInvokeHasNext && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.needInvokeHasNext = true;
        this.hasNext = this.unlimited || --this.limitSize >= 0;
        return this.currentIndex;
    }
}

