/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.iterators.impl;

import java.util.Iterator;

public class LimitedIteratorWrapper<T>
implements Iterator<T> {
    private Iterator<T> source;
    private boolean isNoEmpty;
    private boolean unlimited;
    private int limitSize;

    public LimitedIteratorWrapper(Iterator<T> source, int limitSize) {
        this.reset(source, limitSize);
    }

    @Override
    public boolean hasNext() {
        return this.isNoEmpty && this.source.hasNext();
    }

    @Override
    public T next() {
        this.isNoEmpty = this.unlimited || --this.limitSize >= 0;
        if (this.isNoEmpty) {
            return this.source.next();
        }
        throw new IndexOutOfBoundsException("EOF");
    }

    public final void reset(Iterator<T> source, int limitSize) {
        this.source = source;
        this.isNoEmpty = this.source != null && (this.limitSize = limitSize) != 0;
        this.unlimited = limitSize < 0;
    }
}

