/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.iterators.impl;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.data.disf.iterators.impl.ArrayIterator;

public class MultiArrayIterator<E>
implements Iterator<E> {
    private List<E[]> sourceList = new LinkedList<E[]>();
    private Iterator<E[]> listIterator;
    private ArrayIterator<E> currentArrayIterator;
    private int totalLength;
    private int[] arrayStartIndex;

    public MultiArrayIterator(E[][] sourceArrays) {
        this.reset(sourceArrays);
    }

    public MultiArrayIterator(Collection<E[]> sourceCollections) {
        this.reset(sourceCollections);
    }

    protected boolean fetchNextIterator() {
        while (this.listIterator.hasNext()) {
            E[] arrayBuf = this.listIterator.next();
            if (arrayBuf == null || arrayBuf.length <= 0) continue;
            this.currentArrayIterator.reset(arrayBuf);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.currentArrayIterator.hasNext() || this.fetchNextIterator();
    }

    @Override
    public E next() {
        return this.currentArrayIterator.next();
    }

    public final void reset(E[][] sourceArrays) {
        if (sourceArrays == null) {
            throw new IllegalArgumentException("Invalid Source Array: Cannot be null");
        }
        this.reset(Arrays.asList(sourceArrays));
    }

    public final void reset(Collection<E[]> sourceCollections) {
        if (sourceCollections == null) {
            throw new IllegalArgumentException("Invalid Source Array: Cannot be null");
        }
        this.sourceList.clear();
        this.arrayStartIndex = new int[sourceCollections.size()];
        this.totalLength = 0;
        int i = 0;
        for (E[] array : sourceCollections) {
            if (array == null || array.length <= 0) continue;
            this.sourceList.add(array);
            this.arrayStartIndex[i] = this.totalLength;
            this.totalLength += array.length;
        }
        this.listIterator = this.sourceList.iterator();
        this.currentArrayIterator = new ArrayIterator(null);
    }

    public E[] toArray(Class<E> clazz) {
        int totalCnt = 0;
        for (E[] e : this.sourceList) {
            if (e == null) continue;
            totalCnt += e.length;
        }
        int resultPos = 0;
        Object[] result = (Object[])Array.newInstance(clazz, totalCnt);
        for (E[] e : this.sourceList) {
            if (e == null || e.length <= 0) continue;
            System.arraycopy(e, 0, result, resultPos, e.length);
            resultPos += e.length;
        }
        return result;
    }

    public int getTotalLength() {
        return this.totalLength;
    }
}

