/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.iterators.impl;

import java.util.Iterator;

public class StringSpliterIterator
implements Iterator<String> {
    protected int splitLength;
    protected char[] sourceValues;
    protected int currentPos = 0;

    public StringSpliterIterator(int splitLength, char[] sourceValues) {
        this.reset(splitLength, sourceValues);
    }

    public final void reset(int splitLength, char[] sourceValues) {
        this.splitLength = splitLength;
        this.sourceValues = sourceValues;
        this.currentPos = 0;
    }

    public void reset(char[] sourceValues) {
        this.sourceValues = sourceValues;
        this.currentPos = 0;
    }

    public void reset(String sourceValues) {
        if (sourceValues != null) {
            this.reset(sourceValues.toCharArray());
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.sourceValues.length;
    }

    @Override
    public String next() {
        int startPos;
        if (this.sourceValues.length - this.currentPos <= this.splitLength) {
            int endPos;
            startPos = this.currentPos;
            this.currentPos = endPos = this.sourceValues.length;
        } else {
            int endPos;
            startPos = this.currentPos;
            for (int i = endPos = this.currentPos + this.splitLength - 1; i > startPos; --i) {
                if (!this.isSpliterChar(this.sourceValues[i])) continue;
                endPos = i;
                break;
            }
            this.currentPos = endPos + 1;
        }
        return new String(this.sourceValues, startPos, this.currentPos - startPos);
    }

    protected boolean isSpliterChar(char charVal) {
        switch (charVal) {
            case ' ': 
            case '(': 
            case ')': 
            case ',': 
            case '.': 
            case ':': 
            case ';': {
                return true;
            }
        }
        return false;
    }
}

