/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.model;

import java.lang.reflect.Array;
import java.util.Collection;
import kd.data.disf.model.IDataMergeStrategy;
import kd.data.disf.model.IMutableArrayBaseObject;

public interface IMutableArray<E>
extends IMutableArrayBaseObject<E>,
Iterable<E> {
    public E getByIndex(int var1);

    public E[] getByIndex(int var1, int var2);

    public int add(E var1);

    public int[] batchAdd(E[] var1);

    default public int[] batchAdd(Collection<E> vals) {
        return this.batchAdd(vals.toArray((Object[])Array.newInstance(this.getElementClassType(), 0)));
    }

    default public void merge(IMutableArray<E> source, IDataMergeStrategy<E> mergeStrategy) {
        int mergeSize;
        if (source == null || mergeStrategy == null) {
            return;
        }
        if (this.size() >= source.size()) {
            mergeSize = source.size();
        } else {
            mergeSize = this.size();
            this.batchAdd(source.getByIndex(mergeSize, source.size() - mergeSize));
        }
        for (int i = 0; i < mergeSize; ++i) {
            this.updateElementByIndex(i, source.getByIndex(i), mergeStrategy);
        }
    }
}

