/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import kd.data.disf.enums.DataUpdateResultTypeEnum;
import kd.data.disf.model.IDataMergeStrategy;

public interface IMutableArrayBaseObject<E> {
    public void clear();

    public void clean();

    @JSONField(serialize=false)
    @JsonIgnore
    public int size();

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isEmpty();

    @JSONField(serialize=false)
    @JsonIgnore
    public Class<E> getElementClassType();

    @JSONField(serialize=false)
    @JsonIgnore
    public E[] getElementArray();

    public boolean isNotNull(int var1);

    public boolean isValidIndex(int var1);

    public E setElementValue(int var1, E var2);

    public void setElementValue(int var1, int var2, Object var3);

    public E updateElementByIndex(int var1, E var2, IDataMergeStrategy<E> var3, boolean var4);

    default public E updateElementByIndex(int index, E newValue, IDataMergeStrategy<E> mergeStrategy) {
        return this.updateElementByIndex(index, newValue, mergeStrategy, false);
    }

    public DataUpdateResultTypeEnum updateValues(int var1, int var2, E var3, IDataMergeStrategy<E> var4, boolean var5);

    public E removeByIndex(int var1);

    @JSONField(serialize=false)
    @JsonIgnore
    default public int notNullCount() {
        int cnt = 0;
        for (E e : this.getElementArray()) {
            if (e == null) continue;
            ++cnt;
        }
        return cnt;
    }

    default public int getNotNullValuePosition(boolean forward, int startPos) {
        return this.getValuePosition(forward, true, startPos);
    }

    default public int getNotNullValuePosition(boolean forward) {
        return this.getValuePosition(forward, true, forward ? 0 : this.size() - 1);
    }

    default public int getNullValuePosition(boolean forward, int startPos) {
        return this.getValuePosition(forward, false, startPos);
    }

    default public int getNullValuePosition(boolean forward) {
        return this.getValuePosition(forward, false, forward ? 0 : this.size() - 1);
    }

    default public int getValuePosition(boolean forward, boolean notNull, int startPos) {
        E[] elementArray = this.getElementArray();
        if (elementArray == null || elementArray.length <= 1) {
            return -1;
        }
        if (notNull) {
            if (forward) {
                for (int i = startPos; i < elementArray.length; ++i) {
                    if (elementArray[i] == null) continue;
                    return i;
                }
            } else {
                for (int i = startPos; i >= 0; --i) {
                    if (elementArray[i] == null) continue;
                    return i;
                }
            }
        } else if (forward) {
            for (int i = startPos; i < elementArray.length; ++i) {
                if (elementArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startPos; i >= 0; --i) {
                if (elementArray[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    default public int getNextStorageValuePosition(boolean forward, int startPos) {
        int result = this.getValuePosition(forward, false, startPos);
        return result >= 0 ? result : this.size();
    }

    default public int getNextStorageValuePosition(boolean forward) {
        int result = this.getValuePosition(forward, false, forward ? 0 : this.size() - 1);
        return result >= 0 ? result : this.size();
    }
}

