/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.model;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.data.disf.model.IMutableArrayBaseObject;

public interface IMutableArrayMap<K, V>
extends IMutableArrayBaseObject<V> {
    public V getByIndex(int var1);

    public V[] getByIndex(int var1, int var2);

    public Map.Entry<K[], V> getEntryByIndex(int var1);

    public Map.Entry<K[], V>[] getEntryByIndex(int var1, int var2);

    public Integer getIndex(K var1);

    public Integer removeIndex(K var1);

    public void addIndex(K var1, int var2);

    public Iterator<Map.Entry<K[], V>> getMultiKeyEntryIterator();

    public Iterator<Map.Entry<K, V>> getEntryIterator();

    default public void addIndex(K[] keys, int index) {
        if (keys != null && keys.length > 0) {
            for (K key : keys) {
                this.addIndex(key, index);
            }
        }
    }

    public void setValue(K var1, V var2);

    public V remove(K var1);

    public int addValue(K var1, V var2);

    default public int computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Integer index = this.getIndex(key);
        if (index == null) {
            index = this.addValue(key, mappingFunction.apply(key));
        }
        return index;
    }

    default public Integer computeIfPresent(K key, Function<? super K, ? extends V> mappingFunction) {
        Integer index = this.getIndex(key);
        if (index != null) {
            this.setElementValue(index, mappingFunction.apply(key));
        }
        return index;
    }

    default public Integer merge(K key, V newValue, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Integer index = this.getIndex(key);
        if (index == null) {
            index = this.addValue(key, newValue);
        } else {
            V oldValue = this.getByIndex(index);
            this.setElementValue(index, oldValue == null ? newValue : remappingFunction.apply(oldValue, newValue));
        }
        return index;
    }
}

