/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.model.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.data.disf.enums.DataValueTypeEnum;
import kd.data.disf.enums.IByteCodeEnum;
import kd.data.disf.model.impl.BasePropModel;
import kd.data.disf.model.impl.IDataBaseModel;
import kd.data.disf.utils.IDataJsonUtil;
import kd.data.disf.utils.IDataValueUtil;

public class IDataAnyValue
extends IDataBaseModel<DataValueTypeEnum, Object, String> {
    private static final long serialVersionUID = 3600593980076750556L;

    public IDataAnyValue() {
    }

    public IDataAnyValue(Object[] v) {
        super(v);
    }

    public IDataAnyValue(DynamicObject sourceDynamicObject) {
        this.loadFromDynamicObject(sourceDynamicObject);
    }

    public IDataAnyValue(DataValueTypeEnum dataType, Object value, String refEntityName) {
        super(dataType, value, refEntityName);
    }

    public IDataAnyValue(DataValueTypeEnum dataType, Object value) {
        super(dataType, value, null);
    }

    public IDataAnyValue(JSONArray jsonArray) {
        super(jsonArray);
    }

    @Override
    protected void fetchBaseValueFromDynamicObject(DynamicObject sourceDynamicObject) {
        this.v1 = DataValueTypeEnum.getEnum(this.getByte(sourceDynamicObject, this.getEntityPropName(0)));
        this.v2 = this.getObject(sourceDynamicObject, this.getEntityPropName(1));
        this.v3 = this.getString(sourceDynamicObject, this.getEntityPropName(2));
    }

    @Override
    protected Object[] appendSerializedArray(Object[] targetArray) {
        targetArray[0] = this.getByteCodeEnumCode((IByteCodeEnum)this.v1);
        targetArray[1] = this.v2;
        targetArray[2] = this.v3;
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        this.v1 = DataValueTypeEnum.getEnum(this.getByte(v, 0));
        this.v3 = this.getString(v, 2);
        if (this.v1 != null) {
            switch ((DataValueTypeEnum)this.v1) {
                case Date: {
                    this.v2 = IDataValueUtil.getDate(v, 1);
                    break;
                }
                case BaseProp: {
                    BasePropModel baseProp = null;
                    if (IDataJsonUtil.isJSonFormat(String.valueOf(v[1]), "v") && (baseProp = IDataValueUtil.getBasePropModel(v, 1)) != null) {
                        this.v2 = baseProp;
                    }
                    if (baseProp != null) break;
                    this.v2 = IDataValueUtil.getLongArray(v, 1);
                    break;
                }
                case Double: {
                    this.v2 = IDataValueUtil.getDouble(v, 1);
                    break;
                }
                case Int: {
                    this.v2 = IDataValueUtil.getInteger(v, 1);
                    break;
                }
                case String: {
                    this.v2 = IDataValueUtil.getString(v, 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Not Support DataValueType:%s, ValueArray=%s", this.v1, Arrays.toString(v)));
                }
            }
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public DataValueTypeEnum getDataType() {
        return (DataValueTypeEnum)this.v1;
    }

    public void setDataType(DataValueTypeEnum dataType) {
        this.v1 = dataType;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Object getValue() {
        return this.v2;
    }

    public void setValue(Object value) {
        if (value != null && this.v1 != null) {
            Class classType;
            switch (this.getDataType()) {
                case Date: {
                    classType = Date.class;
                    break;
                }
                case BaseProp: {
                    classType = BasePropModel.class;
                    break;
                }
                case Double: {
                    classType = Double.class;
                    break;
                }
                case Int: {
                    classType = Integer.class;
                    break;
                }
                case String: {
                    classType = String.class;
                    break;
                }
                default: {
                    this.v2 = value;
                    return;
                }
            }
            this.v2 = ObjectConverter.convert((Object)value, classType, (boolean)false);
        } else {
            this.v2 = value;
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String getRefEntityName() {
        return (String)this.v3;
    }

    public void setRefEntityName(String refEntityName) {
        this.v3 = refEntityName;
    }
}

