/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.model.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.data.disf.fetcher.IElementKeyFetcher;
import kd.data.disf.fetcher.impl.EmptyElementKeyFetcher;
import kd.data.disf.iterators.impl.ArrayIterator;
import kd.data.disf.iterators.impl.ArrayMapEntryIterator;
import kd.data.disf.iterators.impl.ArrayMapMultiKeyEntryIterator;
import kd.data.disf.model.IElementLookupProvider;
import kd.data.disf.model.IMutableArrayMap;
import kd.data.disf.model.impl.IDataMapEntry;
import kd.data.disf.model.impl.IDataMultiKeyMapEntry;
import kd.data.disf.model.impl.IDataMutableArrayTemplate;
import kd.data.disf.utils.IDataBeanUtil;
import kd.data.disf.utils.IDataJsonArraySerialization;
import kd.data.disf.utils.IDataValueUtil;

public class IDataBaseMutableArrayMap<K, V>
extends IDataMutableArrayTemplate<V>
implements IMutableArrayMap<K, V>,
IElementLookupProvider<V> {
    private static final long serialVersionUID = -4179343474738301971L;
    @JSONField(serialize=false)
    @JsonIgnore
    protected IElementKeyFetcher<K, V> elementKeyFetcher;
    @JSONField(serialize=false)
    @JsonIgnore
    protected Map<K, Integer> indexMap;
    @JSONField(serialize=false)
    @JsonIgnore
    protected boolean needSerializeIndexMap;
    @JSONField(serialize=false)
    @JsonIgnore
    protected boolean needSerializKeyFetcher;
    @JSONField(serialize=false)
    @JsonIgnore
    protected transient List<Map.Entry<K, V>> cacheElementList;

    public IDataBaseMutableArrayMap() {
        this.initialization();
    }

    public IDataBaseMutableArrayMap(JSONArray srcJsonArray) {
        if (srcJsonArray != null && !srcJsonArray.isEmpty()) {
            this.setV(srcJsonArray.toArray());
        }
        this.initialization();
    }

    public IDataBaseMutableArrayMap(Class<V> elementClassType, IElementKeyFetcher<K, V> elementKeyFetcher) {
        super(elementClassType);
        this.elementKeyFetcher = elementKeyFetcher;
        this.initialization();
    }

    public IDataBaseMutableArrayMap(Class<V> elementClassType, Class<K> elementKeyClassType) {
        super(elementClassType);
        this.elementKeyFetcher = new EmptyElementKeyFetcher(elementKeyClassType);
        this.initialization();
    }

    public IDataBaseMutableArrayMap(int initSize, Class<V> elementClassType, IElementKeyFetcher<K, V> elementKeyFetcher) {
        super(initSize, elementClassType);
        this.elementKeyFetcher = elementKeyFetcher;
        this.initialization();
    }

    public IDataBaseMutableArrayMap(V[] values, Class<V> elementClassType, IElementKeyFetcher<K, V> elementKeyFetcher) {
        super(values, elementClassType);
        this.elementKeyFetcher = elementKeyFetcher;
        this.initialization();
    }

    @Override
    public String toString() {
        return "RSABaseMutableArrayMap [elementKeyFetcher=" + this.elementKeyFetcher + ", indexMap=" + this.indexMap + ", elementClassType=" + this.elementClassType + ", elementArray=" + (this.elementArray != null && this.elementArray.length > 0 ? Arrays.toString(this.elementArray) : null) + ", cacheElementList=" + this.cacheElementList + "]";
    }

    public IDataBaseMutableArrayMap<K, V> copy() {
        IDataBaseMutableArrayMap<K, V> result = new IDataBaseMutableArrayMap<K, V>(this.elementClassType, this.elementKeyFetcher);
        result.elementArray = Arrays.copyOf(this.elementArray, this.elementArray.length);
        result.needSerializeElementClassType = this.needSerializeElementClassType;
        result.needSerializeIndexMap = this.needSerializeIndexMap;
        result.needSerializKeyFetcher = this.needSerializKeyFetcher;
        result.indexMap = new HashMap<K, Integer>();
        result.indexMap.putAll(this.indexMap);
        return result;
    }

    private final void initialization() {
        this.indexMap = new HashMap<K, Integer>();
        this.needSerializeIndexMap = false;
        this.needSerializKeyFetcher = false;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected boolean isNeedSerializeIndexMap() {
        return this.needSerializeIndexMap;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected boolean isNeedSerializKeyFetcher() {
        return this.needSerializKeyFetcher;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        int size = super.getArraySize();
        if (this.isNeedSerializKeyFetcher()) {
            ++size;
        }
        if (this.isNeedSerializeIndexMap()) {
            ++size;
        }
        return size;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    protected int buildCustomSerializeFlag() {
        int result = super.buildCustomSerializeFlag();
        if (this.isNeedSerializeIndexMap()) {
            result |= 2;
        }
        if (this.isNeedSerializKeyFetcher()) {
            result |= 4;
        }
        return result;
    }

    @Override
    protected void parseCustomSerializeFlag(int customSerializeFlag) {
        this.needSerializeElementClassType = (1 & customSerializeFlag) == 1;
        this.needSerializeIndexMap = (2 & customSerializeFlag) == 2;
        this.needSerializKeyFetcher = (4 & customSerializeFlag) == 4;
    }

    @Override
    protected Object[] appendSerializedArray(Object[] targetArray) {
        super.appendSerializedArray(targetArray);
        int index = super.getArraySize();
        if (this.isNeedSerializKeyFetcher()) {
            targetArray[index++] = this.elementKeyFetcher == null ? null : (this.elementKeyFetcher instanceof IDataJsonArraySerialization ? ((IDataJsonArraySerialization)((Object)this.elementKeyFetcher)).getV() : this.elementKeyFetcher.getClass().getName());
        }
        if (this.isNeedSerializeIndexMap()) {
            targetArray[index] = this.indexMap == null || this.indexMap.isEmpty() ? null : this.indexMap;
        }
        return targetArray;
    }

    @Override
    protected void updateValueArray(Object[] v) {
        block9: {
            block8: {
                super.updateValueArray(v);
                int index = super.getArraySize();
                if (this.isNeedSerializKeyFetcher()) {
                    if (v[index] != null) {
                        Object valBuf = v[index];
                        if (valBuf instanceof JSONArray) {
                            Object[] classNameArray = (String[])((JSONArray)valBuf).toArray((Object[])new String[0]);
                            if (classNameArray.length < 2) {
                                throw new KDBizException(String.format("Invalid Class Name Array: %s", Arrays.deepToString(classNameArray)));
                            }
                            this.elementKeyFetcher = (IElementKeyFetcher)IDataBeanUtil.getClassNewInstance(IDataBeanUtil.getClassByName(classNameArray[0]), IDataBeanUtil.getClassByName((String)classNameArray[1]));
                        } else {
                            this.elementKeyFetcher = (IElementKeyFetcher)IDataBeanUtil.getClassNewInstance(IDataBeanUtil.getClassByName((String)v[index]), new Object[0]);
                        }
                    }
                    ++index;
                }
                this.indexMap.clear();
                if (!this.isNeedSerializeIndexMap()) break block8;
                JSONObject jsonObj = IDataValueUtil.getJSONObject(v, index);
                if (jsonObj == null) break block9;
                for (Map.Entry en : jsonObj.entrySet()) {
                    this.indexMap.put(this.elementKeyFetcher.stringToKey((String)en.getKey()), IDataValueUtil.getInteger(en.getValue()));
                }
                break block9;
            }
            for (int i = 0; i < this.elementArray.length; ++i) {
                if (this.elementArray[i] == null) continue;
                for (K key : this.elementKeyFetcher.getKey(this.elementArray[i])) {
                    this.indexMap.put(key, i);
                }
            }
        }
    }

    @Override
    public Integer getIndex(Object key) {
        return this.indexMap.get(key);
    }

    @Override
    public void setValue(K updateKey, V newElement) {
        Integer index = this.indexMap.get(updateKey);
        if (index != null) {
            this.setElementValue(index, newElement);
        }
    }

    @Override
    public V remove(K key) {
        Integer index = this.indexMap.get(key);
        return index != null ? (V)this.removeByIndex(index) : null;
    }

    @Override
    public void addIndex(K key, int index) {
        this.indexMap.put(key, index);
    }

    @Override
    public V get(Object elementKey) {
        Integer index = this.indexMap.get(elementKey);
        return (V)(index != null ? this.elementArray[index] : null);
    }

    @Override
    public boolean contain(Object elementKey) {
        return this.indexMap.containsKey(elementKey);
    }

    @Override
    public int addValue(K key, V val) {
        Integer index = this.getIndex((Object)key);
        if (index == null) {
            index = this.addNewElement(val);
        } else {
            this.setElementValue(index, val);
        }
        this.addIndex(key, (int)index);
        return index;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<V> getRetainedElements(Set needExcludedElementKeys, IElementKeyFetcher<?, V> keyFetcher) {
        if (this.elementArray == null) {
            return null;
        }
        if (needExcludedElementKeys == null || needExcludedElementKeys.isEmpty()) {
            return new ArrayIterator<Object>(this.elementArray);
        }
        LinkedList<Object> resultList = new LinkedList<Object>();
        if (keyFetcher != null) {
            for (Object object : this.elementArray) {
                boolean needToAdd = true;
                for (Object key : keyFetcher.getKey(object)) {
                    if (!needExcludedElementKeys.contains(key)) continue;
                    needToAdd = false;
                    break;
                }
                if (!needToAdd) continue;
                resultList.add(object);
            }
        } else {
            HashMap<K, Integer> fetchIndexMap = new HashMap<K, Integer>(this.indexMap.size());
            fetchIndexMap.putAll(this.indexMap);
            HashMap reslultFetchIndexMap = new HashMap(this.indexMap.size());
            ArrayList delValList = new ArrayList(this.indexMap.size());
            for (Object e : needExcludedElementKeys) {
                delValList.add(fetchIndexMap.remove(e));
            }
            for (Map.Entry entry : fetchIndexMap.entrySet()) {
                if (delValList.indexOf(entry.getValue()) >= 0) continue;
                reslultFetchIndexMap.put(entry.getKey(), entry.getValue());
            }
            Object[] outputIndexs = reslultFetchIndexMap.values().toArray(new Integer[0]);
            Arrays.sort(outputIndexs);
            Integer n = Integer.MIN_VALUE;
            for (Object index : outputIndexs) {
                void var8_17;
                if (var8_17.equals(index)) continue;
                resultList.add(this.elementArray[(Integer)index]);
                Object object = index;
            }
        }
        return resultList.iterator();
    }

    protected void updateIndex(int startPos, int endPos, IElementKeyFetcher<? extends K, V> elementKeyFetcher) {
        if (this.elementArray != null && this.elementArray.length > 0) {
            for (int i = startPos; i <= endPos; ++i) {
                if (this.elementArray[i] == null) continue;
                this.addIndex((K)elementKeyFetcher.getKey(this.elementArray[i]), i);
            }
        }
    }

    protected void updateIndex(int startPos, int endPos) {
        this.updateIndex(startPos, endPos, this.elementKeyFetcher);
    }

    @Override
    public V removeByIndex(int index) {
        Object val;
        block9: {
            val = super.removeElementByIndex(index);
            if (val == null) break block9;
            if (this.elementKeyFetcher == null) {
                HashMap revIndexMap = new HashMap();
                for (Map.Entry<K, Integer> en : this.indexMap.entrySet()) {
                    revIndexMap.computeIfAbsent(en.getValue(), v -> new LinkedList()).add(en.getKey());
                }
                for (Map.Entry<K, Integer> key : (LinkedList)revIndexMap.get(index)) {
                    this.indexMap.remove(key);
                }
                for (int i = index; i < this.elementArray.length; ++i) {
                    for (Object key : revIndexMap.getOrDefault(i, new LinkedList())) {
                        this.indexMap.put(key, i);
                    }
                }
            } else {
                for (K k : this.elementKeyFetcher.getKey(val)) {
                    this.indexMap.remove(k);
                }
                for (int i = index; i < this.elementArray.length; ++i) {
                    for (K key : this.elementKeyFetcher.getKey(this.elementArray[i])) {
                        this.indexMap.put(key, i);
                    }
                }
            }
        }
        return (V)val;
    }

    @Override
    public Integer removeIndex(K key) {
        return this.indexMap.get(key);
    }

    @Override
    public void clear() {
        super.clear();
        this.indexMap.clear();
    }

    @Override
    public void clean() {
        super.clean();
        this.indexMap.clear();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Map<K, Integer> getIndexMap() {
        return this.indexMap;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public K[] getIndexKeys() {
        return this.indexMap.keySet().toArray((Object[])Array.newInstance(this.getElementKeyClassType(), 0));
    }

    public int[] batchAdd(V[] vals, IElementKeyFetcher valKeyFetcher) {
        return this.batchAdd(Arrays.asList(vals), valKeyFetcher);
    }

    public int[] batchAdd(Collection<V> sourceList, IElementKeyFetcher valKeyFetcher) {
        if (this.elementKeyFetcher == null) {
            throw new IllegalArgumentException("Element Key Fetcher is null, cannot use this method!");
        }
        if (sourceList == null || sourceList.isEmpty()) {
            return new int[0];
        }
        int[] indexRange = this.batchAddElements(sourceList);
        if (indexRange.length > 0) {
            for (int idxVal = indexRange[0]; idxVal <= indexRange[1]; ++idxVal) {
                this.addIndex((K)valKeyFetcher.getKey(this.elementArray[idxVal]), idxVal);
            }
        }
        return indexRange;
    }

    public int[] batchAddWithDefaultelKeyFetcher(V[] vals) {
        if (this.elementKeyFetcher == null) {
            throw new IllegalArgumentException("Element Key Fetcher is null, cannot use this method!");
        }
        return this.batchAdd(Arrays.asList(vals), this.elementKeyFetcher);
    }

    public int[] batchAddWithDefaultelKeyFetcher(Collection<V> sourceList) {
        if (this.elementKeyFetcher == null) {
            throw new IllegalArgumentException("Element Key Fetcher is null, cannot use this method!");
        }
        return this.batchAdd(sourceList, this.elementKeyFetcher);
    }

    public int[] batchAdd(Collection<Map.Entry<K, V>> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return new int[0];
        }
        int[] indexRange = this.batchAddEntryElements(sourceList);
        int keyType = 0;
        for (Map.Entry<K, V> en : sourceList) {
            if (en == null || en.getKey() == null) continue;
            if (en.getKey().getClass().isArray()) {
                keyType = 1;
                break;
            }
            if (!en.getKey().getClass().isAssignableFrom(Collection.class)) break;
            keyType = 2;
            break;
        }
        int idxVal = 0;
        for (Map.Entry<K, V> en : sourceList) {
            if (en == null || en.getKey() == null) continue;
            switch (keyType) {
                case 1: {
                    for (Object key : (Object[])en.getKey()) {
                        this.addIndex(key, idxVal);
                    }
                    break;
                }
                case 2: {
                    for (Object key : (Collection)en.getKey()) {
                        this.addIndex(key, idxVal);
                    }
                    break;
                }
                default: {
                    this.addIndex(en.getKey(), idxVal);
                }
            }
            ++idxVal;
        }
        return indexRange;
    }

    protected int[] batchAddEntryElements(Collection<Map.Entry<K, V>> vals) {
        return this.batchAddElements(vals, Map.Entry::getValue);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Iterator<Map.Entry<K[], V>> getMultiKeyEntryIterator() {
        return new ArrayMapMultiKeyEntryIterator<K, Object>(this.elementArray, this.indexMap, this.getElementKeyClassType());
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Iterator<Map.Entry<K, V>> getEntryIterator() {
        return new ArrayMapEntryIterator<K, Object>(this.elementArray, this.indexMap);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Class<K> getElementKeyClassType() {
        return this.elementKeyFetcher != null ? this.elementKeyFetcher.getKeyClassType() : null;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public IElementKeyFetcher<K, V> getElementKeyFetcher() {
        return this.elementKeyFetcher;
    }

    public void setElementKeyFetcher(IElementKeyFetcher<K, V> elementKeyFetcher) {
        this.elementKeyFetcher = elementKeyFetcher;
    }

    public void setNeedSerializeIndexMap(boolean needSerializeIndexMap) {
        this.needSerializeIndexMap = needSerializeIndexMap;
    }

    public void setNeedSerializKeyFetcher(boolean needSerializKeyFetcher) {
        this.needSerializKeyFetcher = needSerializKeyFetcher;
    }

    @Override
    public V getByIndex(int index) {
        return (V)(index >= 0 && this.elementArray.length > index ? this.elementArray[index] : null);
    }

    @Override
    public V[] getByIndex(int startIndex, int length) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex >= this.elementArray.length) {
            return (Object[])Array.newInstance(this.elementClassType, 0);
        }
        if (startIndex + length >= this.elementArray.length) {
            length = this.elementArray.length - startIndex;
        }
        return Arrays.copyOfRange(this.elementArray, startIndex, startIndex + length);
    }

    @Override
    public Map.Entry<K[], V> getEntryByIndex(int index) {
        if (index < 0 || index > this.elementArray.length) {
            return null;
        }
        if (this.elementKeyFetcher == null) {
            for (Map.Entry<K, Integer> en : this.indexMap.entrySet()) {
                if (index != en.getValue()) continue;
                return new IDataMapEntry<K, Object>(en.getKey(), this.elementArray[en.getValue()]);
            }
            return null;
        }
        Object value = this.elementArray[index];
        return new IDataMapEntry<K[], Object>(this.elementKeyFetcher.getKey(value), value);
    }

    @Override
    public Map.Entry<K[], V>[] getEntryByIndex(int startPos, int limitLength) {
        if (limitLength < 0) {
            return null;
        }
        if (this.elementKeyFetcher == null) {
            return new ArrayMapMultiKeyEntryIterator<K, Object>(this.elementArray, this.indexMap, this.getElementKeyClassType(), startPos, limitLength).getEntriesArray();
        }
        IDataMapEntry[] result = new IDataMapEntry[limitLength];
        int idx = 0;
        for (int i = startPos; i < startPos + limitLength; ++i) {
            Object value = this.elementArray[i];
            result[idx++] = value != null ? new IDataMapEntry<K[], Object>(this.elementKeyFetcher.getKey(value), value) : null;
        }
        return result;
    }

    public void cache(K key, V val) {
        if (val == null) {
            return;
        }
        if (this.cacheElementList == null) {
            this.cacheElementList = new LinkedList<Map.Entry<K, V>>();
        }
        this.cacheElementList.add(new IDataMapEntry<K, V>(key, val));
    }

    public void cache(V val) {
        if (this.elementKeyFetcher == null) {
            throw new IllegalArgumentException("Element Key Fetcher cannot be null!");
        }
        if (val == null) {
            return;
        }
        if (this.cacheElementList == null) {
            this.cacheElementList = new LinkedList<Map.Entry<K, V>>();
        }
        this.cacheElementList.add(new IDataMultiKeyMapEntry<K, V>(this.elementKeyFetcher.getKey(val), val));
    }

    public void clearCache() {
        if (this.cacheElementList != null) {
            this.cacheElementList.clear();
        }
    }

    public void flushCacheToArray() {
        if (this.cacheElementList != null) {
            this.batchAdd(this.cacheElementList);
            this.cacheElementList = null;
        }
    }
}

