/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.model.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import kd.data.disf.enums.DataUpdateResultTypeEnum;
import kd.data.disf.iterators.impl.ArrayIterator;
import kd.data.disf.model.IDataMergeStrategy;
import kd.data.disf.model.IMutableArrayBaseObject;
import kd.data.disf.utils.IDataBeanUtil;
import kd.data.disf.utils.IDataJsonArraySerialization;
import kd.data.disf.utils.IDataJsonUtil;
import kd.data.disf.utils.IDataValueUtil;

public class IDataMutableArrayTemplate<E>
implements IMutableArrayBaseObject<E>,
IDataJsonArraySerialization,
Serializable {
    private static final long serialVersionUID = -1022237152649521062L;
    protected static final int[] EmptyIndexArray = new int[0];
    @JSONField(serialize=false)
    @JsonIgnore
    protected Class<E> elementClassType;
    @JSONField(serialize=false)
    @JsonIgnore
    protected E[] elementArray;
    @JSONField(serialize=false)
    @JsonIgnore
    protected boolean needSerializeElementClassType;
    public static final int customSerializeFlagIndex = 0;
    public static final int elementArrayIndex = 1;
    public static final int elementClassTypeIndex = 2;

    public IDataMutableArrayTemplate() {
        this.needSerializeElementClassType = true;
    }

    public IDataMutableArrayTemplate(Class<E> elementClassType) {
        this.elementClassType = elementClassType;
        this.needSerializeElementClassType = true;
    }

    public IDataMutableArrayTemplate(int initSize, Class<E> elementClassType) {
        this.elementClassType = elementClassType;
        this.elementArray = this.createArray(initSize);
        this.needSerializeElementClassType = true;
    }

    public IDataMutableArrayTemplate(E[] values, Class<E> elementClassType) {
        this.elementArray = values;
        this.elementClassType = elementClassType;
        this.needSerializeElementClassType = true;
    }

    public String toString() {
        return "RSAMutableArrayTemplate [elementClassType=" + this.elementClassType + ", needSerializeElementClassType=" + this.needSerializeElementClassType + ", elementArray=" + Arrays.toString(this.elementArray) + "]";
    }

    public IDataMutableArrayTemplate<E> copy() {
        IDataMutableArrayTemplate<E> result = new IDataMutableArrayTemplate<E>(Arrays.copyOf(this.elementArray, this.elementArray.length), this.elementClassType);
        result.needSerializeElementClassType = this.needSerializeElementClassType;
        return result;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected int getArraySize() {
        return (this.needSerializeElementClassType ? 2 : 1) + 1;
    }

    @Override
    public Object[] getV() {
        return this.appendSerializedArray(new Object[this.getArraySize()]);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected int buildCustomSerializeFlag() {
        return this.needSerializeElementClassType ? 1 : 0;
    }

    protected void parseCustomSerializeFlag(int customSerializeFlag) {
        this.needSerializeElementClassType = (1 & customSerializeFlag) == 1;
    }

    protected Object[] appendSerializedArray(Object[] targetArray) {
        targetArray[0] = this.buildCustomSerializeFlag();
        E[] EArray = targetArray[1] = this.elementArray != null && this.elementArray.length > 0 ? this.elementArray : this.createArray(0);
        if (this.needSerializeElementClassType) {
            targetArray[2] = this.getElementClassType() != null ? this.getElementClassType().getName() : null;
        }
        return targetArray;
    }

    @Override
    public void setV(Object[] v) {
        if (v == null) {
            return;
        }
        if (v.length < 2) {
            throw new IllegalArgumentException(String.format("Expect Array Mininal Size:2, but acutal size=%s", v.length));
        }
        this.parseCustomSerializeFlag(IDataValueUtil.getInteger(v, 0));
        this.updateValueArray(v);
    }

    protected void updateValueArray(Object[] v) {
        JSONArray jsonArray;
        if (this.needSerializeElementClassType && this.elementClassType == null) {
            this.elementClassType = IDataBeanUtil.getClassByName(IDataValueUtil.getString(v, 2));
        }
        if ((jsonArray = IDataValueUtil.getJSONArray(v, 1)) != null) {
            this.elementArray = IDataJsonUtil.convertFromJSonArray(jsonArray.toArray(), this.elementClassType);
        }
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isEmpty() {
        return this.elementArray == null || this.elementArray.length == 0;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int size() {
        return this.elementArray == null ? 0 : this.elementArray.length;
    }

    @Override
    public void clear() {
        this.elementArray = this.createArray(0);
    }

    public void clear(int newSize) {
        this.elementArray = this.createArray(newSize);
    }

    @Override
    public void clean() {
        for (int i = 0; i < this.elementArray.length; ++i) {
            this.elementArray[i] = null;
        }
    }

    protected final E[] createArray(int size) {
        return (Object[])Array.newInstance(this.getElementClassType(), size);
    }

    @Override
    public boolean isNotNull(int index) {
        return index >= 0 && index < this.elementArray.length ? this.elementArray[index] != null : false;
    }

    @Override
    public boolean isValidIndex(int index) {
        return this.elementArray != null && index >= 0 && this.elementArray.length > index;
    }

    public E getByIndex(int index) {
        return this.isValidIndex(index) ? (E)this.elementArray[index] : null;
    }

    public E[] getByIndex(int startIndex, int length) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex >= this.elementArray.length) {
            return (Object[])Array.newInstance(this.elementClassType, 0);
        }
        return Arrays.copyOfRange(this.elementArray, startIndex, Math.min(startIndex + length, this.elementArray.length));
    }

    protected boolean ensureCapacity(int endOffset) {
        if (this.elementArray == null) {
            this.elementArray = this.createArray(endOffset + 1);
        } else {
            if (this.elementArray.length > endOffset) {
                return false;
            }
            this.elementArray = Arrays.copyOf(this.elementArray, endOffset + 1);
        }
        return true;
    }

    protected int addNewElement(E val) {
        int index = 0;
        if (this.elementArray == null) {
            this.elementArray = this.createArray(1);
            index = 0;
        } else {
            index = this.elementArray.length;
            this.elementArray = Arrays.copyOf(this.elementArray, index + 1);
        }
        this.elementArray[index] = val;
        return index;
    }

    protected int[] batchAddElements(E[] vals) {
        return this.batchAddElements(Arrays.asList(vals));
    }

    protected <ITEM> int[] batchAddElements(Collection<ITEM> vals, Function<ITEM, E> elementParserFun) {
        int sourceSize;
        if (vals == null || (sourceSize = vals.size()) <= 0) {
            return EmptyIndexArray;
        }
        short index = 0;
        if (this.elementArray == null) {
            this.elementArray = this.createArray(sourceSize);
            index = 0;
        } else {
            index = (short)this.elementArray.length;
            this.elementArray = Arrays.copyOf(this.elementArray, index + sourceSize);
        }
        int[] result = new int[]{index, this.elementArray.length - 1};
        if (elementParserFun != null) {
            for (ITEM v : vals) {
                short s = index;
                index = (short)(index + 1);
                this.elementArray[s] = elementParserFun.apply(v);
            }
        } else {
            for (ITEM v : vals) {
                short s = index;
                index = (short)(index + 1);
                this.elementArray[s] = v;
            }
        }
        return result;
    }

    protected <ITEM> int[] batchAddElements(Collection<ITEM> vals) {
        return this.batchAddElements(vals, null);
    }

    @Override
    public E removeByIndex(int index) {
        return this.removeElementByIndex(index);
    }

    protected E removeElementByIndex(int index) {
        if (this.elementArray == null || index < 0 || index >= this.elementArray.length) {
            return null;
        }
        E result = this.elementArray[index];
        E[] newArray = this.createArray(this.elementArray.length - 1);
        if (newArray.length > 0) {
            if (index > 0) {
                System.arraycopy(this.elementArray, 0, newArray, 0, index);
            }
            System.arraycopy(this.elementArray, index + 1, newArray, index, this.elementArray.length - 1 - index);
        }
        this.elementArray = newArray;
        return result;
    }

    @Override
    public E setElementValue(int index, E val) {
        this.ensureCapacity(index);
        this.elementArray[index] = val;
        return val;
    }

    @Override
    public void setElementValue(int startOffset, int endOffset, Object newValue) {
        E v = this.elementClassType.cast(newValue);
        int oldSize = this.elementArray.length;
        if (endOffset >= oldSize) {
            this.ensureCapacity(endOffset);
        }
        for (int i = startOffset; i <= endOffset; ++i) {
            this.elementArray[i] = v;
        }
    }

    @Override
    public E updateElementByIndex(int index, E newValue, IDataMergeStrategy<E> mergeStrategy, boolean autoExpend) {
        if (index >= this.elementArray.length && autoExpend) {
            this.ensureCapacity(index);
            this.elementArray[index] = newValue;
        } else {
            this.elementArray[index] = mergeStrategy.mergeValue(index, null, this.elementArray[index], newValue);
        }
        return this.elementArray[index];
    }

    @Override
    public DataUpdateResultTypeEnum updateValues(int startOffset, int endOffset, E newValue, IDataMergeStrategy<E> mergeStrategy, boolean autoExpend) {
        if (startOffset > endOffset) {
            return DataUpdateResultTypeEnum.Skip;
        }
        int totalSize = this.elementArray.length;
        if (startOffset < 0) {
            startOffset = 0;
        } else if (startOffset > totalSize && !autoExpend) {
            return DataUpdateResultTypeEnum.Skip;
        }
        if (endOffset >= totalSize) {
            if (autoExpend) {
                this.ensureCapacity(endOffset);
            } else {
                endOffset = totalSize - 1;
            }
        }
        DataUpdateResultTypeEnum result = startOffset >= totalSize ? DataUpdateResultTypeEnum.New : DataUpdateResultTypeEnum.Merged;
        for (int i = startOffset; i <= endOffset; ++i) {
            this.elementArray[i] = mergeStrategy.mergeValue(this.elementArray[i], newValue);
        }
        return result;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public E[] getElementArray() {
        return this.elementArray == null ? this.createArray(0) : this.elementArray;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Class<E> getElementClassType() {
        return this.elementClassType;
    }

    public void setElementClassType(Class<E> elementClassType) {
        this.elementClassType = elementClassType;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Iterator<E> iterator() {
        return new ArrayIterator<E>(this.elementArray);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isNeedSerializeElementClassType() {
        return this.needSerializeElementClassType;
    }

    public void setNeedSerializeElementClassType(boolean needSerializeElementClassType) {
        this.needSerializeElementClassType = needSerializeElementClassType;
    }
}

