/*
 * Decompiled with CFR 0.152.
 */
package kd.data.disf.model.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.math.BigInteger;
import kd.data.disf.enums.IDataNumberCardinalityEnum;
import kd.data.disf.utils.IDataJsonArraySerialization;
import kd.data.disf.utils.IDataValueUtil;

public class IDataNumberValue
implements IDataJsonArraySerialization {
    private static final long serialVersionUID = -6497114159951858667L;
    private static final int MaxValueLength = 9;
    private static final int MaxZeroCnt = 15;
    private static final char ZeroChar = '0';
    @JSONField(serialize=false)
    @JsonIgnore
    protected byte valueInfo;
    @JSONField(serialize=false)
    @JsonIgnore
    protected int intPart;
    @JSONField(serialize=false)
    @JsonIgnore
    protected int decimalPart;

    public IDataNumberValue() {
    }

    public IDataNumberValue(int value) {
    }

    public IDataNumberValue(Double sourceValue) {
        this.reset(sourceValue.toString());
    }

    public IDataNumberValue(Float sourceValue) {
        this.reset(sourceValue.toString());
    }

    public IDataNumberValue(BigDecimal sourceValue) {
        this.reset(sourceValue.toString());
    }

    public IDataNumberValue(IDataNumberCardinalityEnum baseValueType, int intPart, int decimalPart, int scale) {
        this.valueInfo = this.buildValueInfo(baseValueType, scale);
        this.intPart = intPart;
        this.decimalPart = decimalPart;
    }

    public void reset(IDataNumberCardinalityEnum baseValueType, int intPart, int decimalPart, int scale) {
        this.valueInfo = this.buildValueInfo(baseValueType, scale);
        this.intPart = intPart;
        this.decimalPart = decimalPart;
    }

    public final void reset(String srcValueString) {
        this.reset(srcValueString, -1, null);
    }

    public static String[] trimInValidZero(String[] srcValueString) {
        int pos;
        if (srcValueString == null || srcValueString.length == 0) {
            return srcValueString;
        }
        String checkStr = srcValueString[0];
        for (pos = 0; pos < checkStr.length() && '0' == checkStr.charAt(pos); ++pos) {
        }
        srcValueString[0] = srcValueString[0].substring(pos);
        if ("".equals(srcValueString[0])) {
            srcValueString[0] = "0";
        }
        if (srcValueString.length > 1) {
            checkStr = srcValueString[1];
            for (pos = checkStr.length() - 1; pos >= 0 && '0' == checkStr.charAt(pos); --pos) {
            }
            srcValueString[1] = pos < 0 || pos > checkStr.length() - 1 ? null : srcValueString[1].substring(0, pos + 1);
        }
        return srcValueString;
    }

    public void reset(String srcValueString, int maxDisplayLength, IDataNumberCardinalityEnum baseValueType) {
        this.decimalPart = 0;
        int scale = 2;
        if (srcValueString != null && !"".equals(srcValueString.trim())) {
            String[] splitStrs = srcValueString.split("\\.");
            splitStrs = IDataNumberValue.trimInValidZero(splitStrs);
            maxDisplayLength = maxDisplayLength < 0 ? 9 : Math.min(maxDisplayLength, 9);
            int decZeroCnt = 0;
            String decimalStr = "";
            String intStr = splitStrs[0];
            boolean hasDecimalPart = false;
            if (splitStrs.length > 1) {
                decimalStr = splitStrs[1];
                hasDecimalPart = decimalStr != null && !"".equals(decimalStr);
            }
            int cardinalityBase = 0;
            int shiftIntLength = 0;
            boolean intPartNeedRoundUp = false;
            boolean decimalPartNeedRoundUp = false;
            if (intStr.length() > 0) {
                int endPos = intStr.length() - 1;
                while (endPos > 0) {
                    if ('0' != intStr.charAt(endPos)) {
                        ++endPos;
                        break;
                    }
                    --endPos;
                    ++cardinalityBase;
                }
                if (endPos > 25 || cardinalityBase >= 16) {
                    throw new IllegalArgumentException("Number excceed max range: Input=" + intStr);
                }
                if (maxDisplayLength > endPos) {
                    if (endPos > 0) {
                        intStr = intStr.substring(0, endPos);
                    }
                } else {
                    if (baseValueType == null) {
                        shiftIntLength = Math.max(endPos - maxDisplayLength, IDataNumberCardinalityEnum.Thousands.getIntCode());
                    } else if (baseValueType.getIntCode() > cardinalityBase) {
                        shiftIntLength = baseValueType.getIntCode() - cardinalityBase;
                    }
                    if (shiftIntLength > 0) {
                        String newIntStr = intStr.substring(intStr.length() - shiftIntLength - cardinalityBase, intStr.length());
                        decimalStr = newIntStr + decimalStr;
                        intPartNeedRoundUp = Integer.parseInt(String.valueOf(intStr.charAt(intStr.length() - shiftIntLength - cardinalityBase))) >= 5;
                        intStr = intStr.substring(0, intStr.length() - shiftIntLength - cardinalityBase);
                        cardinalityBase += shiftIntLength;
                        hasDecimalPart = true;
                    } else {
                        if (intStr.length() > maxDisplayLength) {
                            intPartNeedRoundUp = Integer.parseInt(String.valueOf(intStr.charAt(maxDisplayLength + 1))) >= 5;
                            intStr = intStr.substring(0, maxDisplayLength);
                        }
                        cardinalityBase += endPos - maxDisplayLength;
                    }
                }
            }
            if (hasDecimalPart) {
                scale = maxDisplayLength - intStr.length();
                if (scale > 0) {
                    for (decZeroCnt = 0; decZeroCnt < decimalStr.length() && '0' == decimalStr.charAt(decZeroCnt); ++decZeroCnt) {
                    }
                    if (shiftIntLength <= 0 && (scale <= 0 || decZeroCnt > scale)) {
                        decimalStr = null;
                        scale = 0;
                    } else {
                        if (decimalStr.length() > 1) {
                            int decCutLength = Math.min(scale - decZeroCnt, decimalStr.length());
                            if (decCutLength < decimalStr.length() - 1) {
                                decimalPartNeedRoundUp = Integer.parseInt(String.valueOf(decimalStr.charAt(decCutLength + 1))) >= 5;
                            }
                            decimalStr = decimalStr.substring(0, decCutLength);
                        }
                        scale = Math.min(decimalStr.length(), scale);
                    }
                } else {
                    hasDecimalPart = false;
                    decimalStr = null;
                }
            }
            this.decimalPart = 0;
            if (hasDecimalPart && decimalStr != null) {
                try {
                    this.decimalPart = Integer.parseInt(decimalStr.substring(0, Math.min(9, decimalStr.length())));
                    if (decimalPartNeedRoundUp) {
                        ++this.decimalPart;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.intPart = Integer.parseInt(intStr);
            if (intPartNeedRoundUp) {
                ++this.intPart;
            }
            this.valueInfo = this.buildValueInfo(cardinalityBase, Math.max(0, scale));
        } else {
            this.valueInfo = 0;
            this.intPart = 0;
        }
    }

    public static void main(String[] args) {
        IDataNumberValue val = new IDataNumberValue();
        val.reset("123456", 5, null);
    }

    public void reset(IDataNumberCardinalityEnum baseValueType, int intPart) {
        this.reset(baseValueType, intPart, 0, 0);
    }

    public void reset(int intPart) {
        this.reset(IDataNumberCardinalityEnum.One, intPart, 0, 0);
    }

    public void reset(int intPart, int decimalPart, int scale) {
        this.reset(IDataNumberCardinalityEnum.One, intPart, decimalPart, scale);
    }

    public String toString() {
        return "RSANumberValue [valueInfo=" + this.valueInfo + ", intPart=" + this.intPart + ", decimalPart=" + this.decimalPart + "]";
    }

    protected final byte buildValueInfo(IDataNumberCardinalityEnum baseValueType, int scale) {
        return this.buildValueInfo(baseValueType.getIntCode(), scale);
    }

    protected byte buildValueInfo(int baseValueType, int scale) {
        return (byte)(baseValueType << 4 | (byte)Math.min(scale, 15) & 0xF);
    }

    protected long buildStorageValue(int intValue, int decimalValue) {
        return (long)intValue << (this.valueInfo & 0xF) | (long)decimalValue;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public BigDecimal getFullValue() {
        return new BigDecimal(this.buildFullNumberString());
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public String buildFullNumberString() {
        StringBuilder buf = new StringBuilder();
        byte cardinalityBase = this.getCardinalityBase();
        int scale = this.getScale();
        if (scale <= 0) {
            return Integer.toString(this.intPart) + IDataNumberCardinalityEnum.getSuffixZeroString(cardinalityBase);
        }
        String intPartStr = Integer.toString(this.intPart);
        buf.append(intPartStr).append(Integer.toString(this.decimalPart)).append(IDataNumberCardinalityEnum.getSuffixZeroString(cardinalityBase));
        String result = buf.toString();
        int splitPos = cardinalityBase + intPartStr.length();
        if (splitPos < result.length()) {
            return result.substring(0, splitPos) + "." + result.substring(splitPos, result.length());
        }
        return result;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public BigInteger getFullIntPart() {
        BigInteger intVal = BigInteger.valueOf(this.intPart);
        byte cardinalityBase = this.getCardinalityBase();
        if (cardinalityBase > 0) {
            return intVal.multiply(BigInteger.valueOf(10L).pow(cardinalityBase));
        }
        return intVal;
    }

    public String getIntString() {
        return Integer.toString(this.intPart) + IDataNumberCardinalityEnum.getSuffixZeroString(this.getCardinalityBase());
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public BigDecimal getFullDecimalPart() {
        int scale = this.getScale();
        if (scale > 0) {
            return BigDecimal.valueOf(this.decimalPart).divide(BigDecimal.valueOf(10L).pow(scale));
        }
        return BigDecimal.ZERO;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getIntPart() {
        return this.intPart;
    }

    public void setIntPart(int intPart) {
        this.intPart = intPart;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getDecimalPart() {
        return this.decimalPart;
    }

    public void setDecimalPart(int decimalPart) {
        this.decimalPart = decimalPart;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public byte getValueInfo() {
        return this.valueInfo;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getScale() {
        return this.valueInfo & 0xF;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public byte getCardinalityBase() {
        return (byte)(this.valueInfo >> 4 & 0xF);
    }

    @Override
    public Object[] getV() {
        return new Object[]{this.valueInfo, this.intPart, this.decimalPart};
    }

    @Override
    public void setV(Object[] v) {
        this.valueInfo = IDataValueUtil.getByte(v, 0);
        this.intPart = IDataValueUtil.getInteger(v, 1);
        this.decimalPart = IDataValueUtil.getInteger(v, 2);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void setToTarget(int length) {
        String intPartStr = String.valueOf(this.intPart);
        int curLength = intPartStr.length() - length;
        if (intPartStr.length() > length) {
            this.valueInfo = this.buildValueInfo(IDataNumberCardinalityEnum.getEnum((byte)curLength), 0);
            intPartStr = intPartStr.substring(0, length);
            this.intPart = Integer.parseInt(intPartStr);
            this.decimalPart = 0;
        } else {
            this.valueInfo = this.buildValueInfo(IDataNumberCardinalityEnum.One, curLength);
            intPartStr = String.valueOf(this.decimalPart);
            intPartStr = intPartStr.substring(0, curLength);
            this.decimalPart = Integer.parseInt(intPartStr);
        }
    }
}

